/**
 * 基本信息
 *
 * @format
 */

import { BaseDao, TBAPIS } from '../../sdk'
import { ACTIVITY_CONFIG_DB_NAME } from '../../db'
import { ACTIVITY_STATUS } from '../../constants'

export default class BaseService {
  context: IContext<any>
  activitydao: IBaseDao
  constructor(context: IContext<any>) {
    this.context = context
    this.activitydao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME)
  }
  /**
   * @desc 活动基本信息
   * @param {活动id} activityId
   * @returns 返回活动详情，若不存在活动，返回为null
   */
  async getBaseInfo(activityId: string): Promise<IActivityInfo> {
    return await this.activitydao.findOne({ _id: activityId, deleteStatus: ACTIVITY_STATUS.NORMAL })
  }

  /**
   *
   * 根据itemIds获取商品列表
   *
   * @param {string} itemIds
   * @return {Array}
   * @memberof BaseService
   */
  async getItemListByIds(itemIds: string): Promise<{ list: ITaoBaoItems[] }> {
    const GOODSINFO =
      'detail_url,approve_status,num_iid,title,nick,type,cid,pic_url,num,props,valid_thru,list_time,desc,price,has_discount,has_invoice,has_warranty,has_showcase,modified,delist_time,postage_id,seller_cids,outer_id,sold_quantity'
    const result = await TBAPIS.getItemListByItemIds(this.context, itemIds, { fields: GOODSINFO })
    const items = result?.items?.item || []
    const list = items.map(
      (v: { num_iid: string; title: string; price: string; detail_url: string; pic_url: string; desc: string }) => {
        return {
          itemId: v.num_iid,
          name: v.title,
          price: v.price,
          url: v.detail_url,
          image: v.pic_url,
          desc: v.desc
        }
      }
    )
    return { list }
  }
}
