/** @format */
import CommonUserController from './controller/user.controller'
const CommonUserControllerInstance = new CommonUserController()
import CommonTaskController from './controller/task.controller'
const CommonTaskControllerInstance = new CommonTaskController()
import CommonLoginController from './controller/login.controller'
const CommonLoginControllerInstance = new CommonLoginController()
import CommonBaseController from './controller/base.controller'
const CommonBaseControllerInstance = new CommonBaseController()
import CommonStatController from './controller/stat.controller'
const CommonStatControllerInstance = new CommonStatController()
import CommonAwardsController from './controller/awards.controller'
const CommonAwardsControllerInstance = new CommonAwardsController()
import CommonShareController from './controller/share.controller'
const CommonShareControllerInstance = new CommonShareController()

import CommonCardController from './controller/card.controller'

const {
  getAwardsCarouselList,
  getCollectCardInfo,
  getGiftCard,
  getMyCardsInfo,
  doJoin,
  doGiftCard
} = new CommonCardController()

export default {
  getVipInfo: CommonUserControllerInstance.getVipInfo,
  getRankList: CommonUserControllerInstance.getRankList,
  getTaskList: CommonTaskControllerInstance.getTaskList,
  doCompleteTask: CommonTaskControllerInstance.doCompleteTask,
  receiveTaskRewards: CommonTaskControllerInstance.receiveTaskRewards,
  getCollectGoodsList: CommonTaskControllerInstance.getCollectGoodsList,
  login: CommonLoginControllerInstance.login,
  getActivityBaseInfoById: CommonBaseControllerInstance.getActivityBaseInfoById,
  getItemListByItemIds: CommonBaseControllerInstance.getItemListByItemIds,
  addStat: CommonStatControllerInstance.addStat,
  getStats: CommonStatControllerInstance.getStats,
  getMyPrizeList: CommonAwardsControllerInstance.getMyPrizeList,
  receiveObjectPrize: CommonAwardsControllerInstance.receiveObjectPrize,
  receiveEnamePrize: CommonAwardsControllerInstance.receiveEnamePrize,
  drawLotteryPrize: CommonAwardsControllerInstance.drawLotteryPrize,
  getShareInfo: CommonShareControllerInstance.getShareInfo,
  doHelp: CommonShareControllerInstance.doHelp,
  // 卡牌类
  getAwardsCarouselList,
  getCollectCardInfo,
  getGiftCard,
  doGiftCard,
  getMyCardsInfo,
  doJoin
}
