/** @format */

import { services, preCheck, registeInfos, preUpdate, checkParams } from '../decorator/common/'
import { resultsModel } from '../sdk'
import { CommonUserService, CommonStatService, CommonTaskService, CommonAwardsService } from '../service/common'
import { PRIZE_DATA_TYPE, STAT_TYPE } from '../constants'
import { checkActivityTime, checkInviteId, checkHelpRecord, checkNewVip } from '../utils/common/check'
import { updateHelpRecord, updateVip } from '../utils/common/update/'

export default class Share {
  /**
   *  获取邀请信息
   */
  @checkParams(['activityId'])
  @services([CommonUserService])
  async getShareInfo(context: IContext<IParams>, { userInfo }: IControllerInfos, [userService]: [CommonUserService]) {
    const result = await userService.queryDataByKey('remainTimes.invites', userInfo, 'rewards')

    return resultsModel.success(result)
  }
  /**
   *  完成分享
   */
  @checkParams(['activityId', 'inviteId'])
  @registeInfos(['vipInfo'])
  @services([CommonTaskService, CommonStatService, CommonAwardsService])
  @preCheck([checkActivityTime, checkInviteId, checkNewVip, checkHelpRecord])
  @preUpdate([updateVip, updateHelpRecord])
  async doHelp(
    context: IContext<IParams>,
    { userInfo, activityInfo }: IControllerInfos,
    [taskService, statService, awardService]: [CommonTaskService, CommonStatService, CommonAwardsService],
    { inviteUserInfo }: IPreCheckData
  ) {
    const { activityId } = context.data

    const result = await taskService.completeTask('invites', activityInfo, inviteUserInfo)

    if ((result as ICodeType).code) return resultsModel.error(result as ICodeType)

    const drawResult = await awardService.drawLottery(activityId, userInfo, {
      prizeDataType: PRIZE_DATA_TYPE.HELP_SUCCESS
    })

    statService.addStat(STAT_TYPE.INITE_SUCCESS, userInfo)

    return resultsModel.success(drawResult)
  }
}
