/** @format */

export * from './errorCode'

// tb 接口返回部分错误
export const TBERROR = {
  USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY: '今日领取达到上限，明日再来领取哦',
  COUPON_INVALID_OR_DELETED: '权益无效或者被删除，请联系商家',
  APPLY_OWNSELF_COUPON: '不能领取自己家店铺权益',
  APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT: '请至卡券包删除无用权益再领取',
  NO_RIGHT_QUANTITY: '权益库存不足，请联系商家',
  ERRORA_3_567: '领取失败，为风险用户',
  'Invalid session': '订购应用已过期，请联系商家处理'
}

// 领取奖品状态
export const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}

// 订单状态
export const TAOBAO_SUCCESS_ORDER_STATUS: string[] = [
  'WAIT_SELLER_SEND_GOODS',
  'SELLER_CONSIGNED_PART',
  'WAIT_BUYER_CONFIRM_GOODS',
  'TRADE_BUYER_SIGNED',
  'TRADE_FINISHED',
  'PAID_FORBID_CONSIGN'
]

export const ACTIVITY_OPEN_PRIZE_STATUS = {
  //开奖状态
  AWAIT: 1,
  FAIL: 2,
  SUCCESS: 3
}

// 活动状态
export const enum ACTIVITY_STATUS {
  NORMAL = 1,
  DELETE = 2
}

// 奖品状态
export const enum DELETE_STATUS {
  NORMAL = 1,
  DELETE = 2
}

//任务频率类型常量
export const TASK_RATE_TYPE = {
  FOREVER: 1,
  EVERYDAY: 2,
  NOLIMIT: 3
}

//任务状态
export const TASK_STATUS = {
  WAIT_DO: 1, // 未完成
  WAIT_RECEIVE: 2, // 待领取
  DONE: 3 // 已完成
}

// 奖品类型
export const PRIZE_TYPE = {
  ENAME: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANKS: 5,
  CARD: 6
}

// 奖品分类
export const PRIZE_DATA_TYPE = {
  RANKING: 1, // 排行榜
  PROBABILITY: 2, // 概率
  CARD: 6, // 卡牌
  CARD_TYPE_AWARD: 7,
  JOIN_TIMES: 8,
  HELP_SUCCESS: 9
}

// 奖品是否限制库存
export enum SWICH_TOCK {
  LIMIT = 1,
  NO_LIMIT = 2
}

//物流状态
export const SHIP_STATUS = {
  NO_ADDRESS: 1,
  NO_SHIP: 2,
  HAS_SHIP: 3
}

// 记录数据
export enum STAT_TYPE {
  INITE_SUCCESS = 0,
  MY_CARD = 1,
  DO_TASK = 2,
  INVITE,
  HELP,
  HELP_WON_PRIZE,
  GIFT_CARD,
  GIFT_CARD_WON_PRIZE,
  COLLECT_GOODS,
  ORDER,
  ACCESS_FROM_GIFT_CARD,
  ORDER_RECORD
}

// 集卡阶梯奖励状态
export enum CARD_PRIZE_STATUS {
  LOCK = 1,
  UN_LOCK,
  SUCCESS
}

// 免费次数赠送类型
export enum FREE_TYPE {
  FOERVER = 1,
  EVERY_DAY = 2
}

// 参与限制
export enum JOIN_LIMIT {
  NO_LIMIT = 1,
  VIP = 2
}

// 功能开启状态
export enum FEATURE_OPEN_STATUS {
  CLOSE = 1,
  OPEN = 2
}

// 赠送卡片是否开启
export const GIFT_CARD_STATUS = FEATURE_OPEN_STATUS.OPEN

// 任务模块是否开启
export const TASK_OPEN_STATUS = FEATURE_OPEN_STATUS.OPEN

// 每次参与消耗次数
export const JOIN_NEED_TIMES = 1

export const appId = '${需要补充}'

// 商铺id 拼接vip链接用
export const sellerId = '${商铺id}'

// C端的APP NAME
export const C_APP_NAME: string = `promotioncenter-${appId}`
