/** @format */

import { BaseDao, TBAPIS, resultsModel } from '../sdk'
import { SELLER_INFO_DB_NAME, ACTIVITY_CONFIG_DB_NAME } from '../db'

import {
  DELETE_STATUS,
  OPEN_PRIZE_STATUS,
  CODE_TYPES,
  GOODSINFO,
  B_APP_NAME,
  TEMPLATE_INFO,
  APP_SUB_CODE
} from '../constants'
import { MathRand, getConsumerSeller } from '../utils'

export default class ActivityTopService {
  activitySellerDao: IBaseDao
  activityBaseDao: IBaseDao
  context: Context
  constructor(context: Context) {
    this.activitySellerDao = new BaseDao(context, SELLER_INFO_DB_NAME)
    this.activityBaseDao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME)
    this.context = context
  }

  //获取商家授权session
  async getAccessTokenByShopId(activityId: string) {
    let result = await this.activityBaseDao.findOne({ _id: activityId })

    if (!result) return {}
    const { shopId } = result || {}
    let { sellResult } = await this.activitySellerDao.findOne({ shopId }, { sort: { createTime: 1 } })
    console.log(sellResult, 'sellResult')
    return { session: sellResult?.accessToken }
  }

  //通过openId去查找session
  async getAccessTokenByOpenId() {
    const { openId } = this.context
    let result = await this.activitySellerDao.findOne({ openId })
    return { session: result?.accessToken || this.context.accessToken }
  }

  //淘宝top接口获取商品列表
  async getItemListByIds(itemIds: string, seesion: string) {
    try {
      let result = await TBAPIS.getItemListByItemIds(this.context, itemIds, { fields: GOODSINFO })

      if (result) {
        let itemsData = {
          list:
            (result &&
              result.items &&
              result.items.item.reduce(
                (s: any[], v: { num_iid: any; title: any; price: any; detail_url: any; pic_url: any }) => {
                  return (s = [
                    ...s,
                    {
                      itemId: v.num_iid,
                      name: v.title,
                      price: v.price,
                      detailUrl: v.detail_url,
                      picUrl: v.pic_url
                    }
                  ])
                },
                []
              )) ||
            [],
          totalCount: result.items.item.length
        }
        return resultsModel.success(itemsData)
      }
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取商家ids列表失败')
    } catch (e) {
      console.log(e, '获取ids商品列表失败')
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取商家ids列表失败')
    }
  }

  //淘宝top接口获取权益商品信息
  async getPrizeByEname(session: string, ename: string) {
    // sellerConfig = await this.getAccessTokenByOpenId()
    // ename = this.context.data.ename

    console.log(session, 'session')

    let benefitData = await TBAPIS.getPrizeByEname(this.context, ename, B_APP_NAME)

    console.log(benefitData, benefitData.result, 'benefitData.result.')

    if (benefitData?.result?.success) {
      const { result } = benefitData
      let data = result?.datas?.['oright_dto'].reduce(
        (
          s: any[],
          v: {
            benefit_name: any
            right_type_id: number
            start_date: string | number | Date
            end_date: string | number | Date
            amount: number
          }
        ) => {
          return (s = [
            ...s,
            {
              benefitName: v.benefit_name,
              rightTypeId: v.right_type_id == 3 ? 1 : v.right_type_id,
              startTime: new Date(v.start_date).getTime(),
              endTime: new Date(v.end_date).getTime(),
              amount: v.amount ? v.amount / 100 + '' : ''
            }
          ])
        },
        []
      )
      console.log(JSON.stringify(result), 'alibaba.benefit.query')
      return resultsModel.success(data)
    }
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取ename商品信息失败')
  }

  //淘宝top接口获取店铺信息
  async getShopId() {
    let sellerInfo = await this.getAccessTokenByOpenId()
    console.log(sellerInfo, 'getShopId sellerInfo')
    try {
      let result = await TBAPIS.getShopInfo(this.context, {
        // session: sellerInfo.session,
        fields: 'sid,title,pic_path'
      })
      console.log(result, 'getShopId result')
      if (result) {
        return resultsModel.success(result.shop)
      } else {
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取淘宝top店铺信息失败')
      }
    } catch (e) {
      console.log(e, '获取店铺信息失败')
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取淘宝top店铺信息失败')
    }
  }

  async getItemListByStatus(session: string, { approveStatus = 'onsale', title = '', pageNo = 1, pageSize = 10 }) {
    // let sellerConfig = await this.getAccessTokenByOpenId()
    const data = { fields: GOODSINFO, pageNo, q: title, title, pageSize, session }
    console.log(data, 'data')

    const result =
      approveStatus === 'onsale'
        ? await TBAPIS.getItemListOnSale(this.context, data)
        : await TBAPIS.getItemListInStock(this.context, data)

    if (!result) return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取商家在售列表失败')
    const { items, total_results } = result
    const itemsData = {
      pageNo,
      pageSize,
      totalPages: Math.ceil(total_results / pageSize),
      totalCount: total_results,
      list:
        items?.item?.reduce(
          (s: any[], v: { num_iid: string; title: string; price: string; approveStatus: string; pic_url: string }) => {
            return (s = [
              ...s,
              {
                itemId: v.num_iid,
                name: v.title,
                price: v.price,
                approveStatus: v.approveStatus || approveStatus,
                picUrl: v.pic_url
              }
            ])
          },
          []
        ) || []
    }
    return resultsModel.success(itemsData)
  }

  async getTemplateInstantiate() {
    let sellerConfig = await this.getAccessTokenByOpenId()
    let data = {
      description: '此应用用于商家引导活动，商家可设置对应的奖品，在一定时间 内出奖，提升店铺用户活跃以及引导购买',
      ext_json: {
        name: 'online'
      },
      icon: 'https://ossgw.alicdn.com/taobao-miniapp/img/0193eaa9cc037b568acd9ccfe68a8499.jpg',
      name: '店铺漂流' + MathRand(),
      ...TEMPLATE_INFO,
      ...sellerConfig
    }
    console.log('getTemplateInstantiateParams', data)
    try {
      let result = await TBAPIS.getTemplateInstantiate(this.context, data)
      if (result) {
        console.log(JSON.stringify(result), 'getTemplateInstantiate')
        return result
      }
      return false
    } catch (e) {
      console.log(e, '获取getTemplateInstantiate失败')
      return false
    }
  }

  //模板小程序上线
  async pushOnlineInstance(instanceInfo: { app_id: any; app_version: any }) {
    let sellerConfig = await this.getAccessTokenByOpenId()
    let data = {
      ...TEMPLATE_INFO,
      ...instanceInfo,
      ...sellerConfig
    }
    console.log('pushOnlineInstanceParams', data)
    try {
      let result = await TBAPIS.pushInstanceOnline(this.context, data)
      if (result) {
        console.log(JSON.stringify(result), 'pushOnlineInstance')
        return result
      }
      return false
    } catch (e) {
      console.log(e, 'pushOnlineInstance失败')
      return false
    }
  }

  async getSubRelationship(nick: string) {
    const cloud = this.context.cloud
    let res = await cloud.topApi.invoke({
      api: 'taobao.vas.subscribe.get',
      data: {
        article_code: APP_SUB_CODE,
        nick
      },
       autoSession: true
    })
    if (res && res['article_user_subscribes'] && res['article_user_subscribes']['article_user_subscribe'])
      return res['article_user_subscribes']['article_user_subscribe'][0]
    return false
  }

  //模板小程序更新
  async updateMiniInstance(instanceInfo: {
    clients: any
    app_id: any
    template_id: any
    ext_json: { name: string }
    template_version: string
  }) {
    let sellerConfig = await this.getAccessTokenByOpenId()
    let data = {
      ...TEMPLATE_INFO,
      ...instanceInfo,
      ...sellerConfig
    }
    try {
      let result = await TBAPIS.updateMiniInstance(this.context, data)
      if (result) {
        console.log(JSON.stringify(result), 'updateMiniInstance')
        return result
      }
      return false
    } catch (e) {
      console.log(e, 'updateMiniInstance失败')
      return false
    }
  }
}
