/** @format */

import { DEFAULT_CODE_TYPES } from './sdk'

export const BusinessError = {
  // 更新重试失败(用于并发更新)
  ERROR_UPDATE_RETRY: {
    code: `210001`,
    defaultMsg: `系统错误`
  },
  // 活动不存在
  ERROR_NO_ACTIVITY: {
    code: `220001`,
    defaultMsg: `活动不存在`
  },
  // 活动未开始
  ERROR_ACTIVITY_NOSTART: {
    code: `220002`,
    defaultMsg: `活动未开始`
  },
  // 活动已结束
  ERROR_ACTIVITY_OVER: {
    code: `220003`,
    defaultMsg: `活动已结束`
  },
  // 用户不存在
  ERROR_NO_USER: {
    code: `310002`,
    defaultMsg: `用户不存在`
  },
  // 需要成为会员才能助力哦
  ERROR_NEEDMEMBER_DOHELP: {
    code: `310004`,
    defaultMsg: '需要成为会员才能助力哦'
  },
  // 非店铺会员
  ERROR_NO_VIP: {
    code: `310005`,
    defaultMsg: '非店铺会员'
  },
  // 任务奖励已领取
  ERROR_TASK_ALREADYRECEIVE: {
    code: `430002`,
    defaultMsg: `任务奖励已领取`
  },
  // 任务已完成
  ERROR_TASK_COMPLETE: {
    code: `430003`,
    defaultMsg: `任务已完成`
  },
  // 暂无次数可领取
  ERROR_TASK_NORECEIVE: {
    code: `430003`,
    defaultMsg: `暂无次数可领取`
  },
  ERROR_INVALID_INVITE_ID: {
    code: `430004`,
    defaultMsg: `邀请码无效`
  },
  ERROR_NO_CREDITS: {
    code: `430005`,
    defaultMsg: `积分不足`
  },
  ERROR_TASK_LIMIT: {
    code: `430006`,
    defaultMsg: `今日完成该任务次数超限`
  },
  ERROR_FORBIDDEN_OPE: {
    code: `530001`,
    defaultMsg: `非法操作`
  },
  ERROR_RECEIVE_PRIZE: {
    code: `630002`,
    defaultMsg: `奖励已领取`
  },
  ERROR_SEND_PRIZE: {
    code: `730001`,
    defaultMsg: `发奖失败`
  },
  ERROR_NO_PRIZE: {
    code: `730002`,
    defaultMsg: `奖品不存在`
  },
  ERROR_NO_STOCK: {
    code: `730003`,
    defaultMsg: `库存不足`
  },
  ERROR_PRIZE_EXPIRED: {
    code: `740001`,
    defaultMsg: `奖品已超过领取时间`
  }
}
// 活动开奖状态码
export const OPEN_PRIZE_STATUS = {
  // 待开奖
  WAIT_AWARD: 1,
  // 开奖中
  PROCESSING: 2,
  // 开奖成功
  SUCCESS: 3,
  // 开奖失败
  FAIL: 4
}

// 领取奖品状态
export const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}

// 日志类型： error，info
export const LOGGER_TYPE = {
  ERROR: 1,
  INFO: 2
}

export const PRIZE_TYPE = {
  EQUITY: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANK: 5
}

export const CODE_TYPES = Object.assign({}, DEFAULT_CODE_TYPES, BusinessError)

export const errorCode = {
  '000000': 'ok',
  '000001': '请填写活动名称',
  '000002': '请填写活动副标题',
  '000003': '活动名称不得大于12个字符',
  '000004': '活动副标题不得大于16个字符',
  '000005': '任务配置至少选择一项',
  '000006': '浏览链接配置错误',
  '000007': '奖品至少配置三名',
  '000008': '浏览宝贝最多选择20个商品',
  '000010': '请先生成规则',
  '000011': '请配置活动时间',
  '000012': '新建活动开始时间需小于当前时间',
  '000013': '开始时间不得大于结束时间',
  '000014': '奖品最多配置8个档位',
  '000015': '查询列表错误',
  '000016': '查询列表总数错误',
  '000017': '更新奖品列表出错',
  '000020': '删除活动失败',
  '000021': '保存活动失败',
  '000022': '删除活动id不存在',
  '000023': '当前活动不存在',
  '000024': '获取授权信息失败',
  '000025': '保存授权信息失败',
  '000026': '获取商家在售列表失败',
  '000027': '获取商家ids列表失败',
  '000030': '获取ename商品信息失败',
  '000031': '奖品配置不正确'
}
// B端的APP NAME
export const B_APP_NAME: string = 'promotioncenter-3000000028145912'

export const GOODSINFO =
  'detail_url,approve_status,num_iid,title,nick,type,cid,pic_url,num,props,valid_thru,list_time,price,has_discount,has_invoice,has_warranty,has_showcase,modified,delist_time,postage_id,seller_cids,outer_id,sold_quantity'

export const EIGHT_HOURS = 60 * 60 * 8 * 1000
export const SEVEN_DAYS = 7 * 24 * 60 * 60 * 1000

export const _48_HOURS = 48 * 60 * 60 * 1000

export const DELETE_STATUS = {
  EXIST: 1,
  DELETE: 2
}

export const TASK_TYPE_TEXT = {
  member: '成为会员',
  follow: '关注店铺',
  sign: '签到',
  exchangeCredits: '兑换积分',
  invites: '邀请好友',
  orderGoods: '下单商品',
  browseGoods: '浏览商品',
  jumpLink: '跳转链接',
  collectGoods: '收藏商品'
}

export const TASK_CHECK_TYPE = {
  value: {
    list: ['member', 'follow', 'sign', 'exchangeCredits', 'invites', 'orderGoods', 'jumpLink', 'collectGoods'],
    reg: /[1-99]/,
    regName: '1-99之内'
  },
  times: {
    list: ['exchangeCredits', 'invites', 'orderGoods', 'browseGoods', 'jumpLink', 'collectGoods']
  },
  title: {
    list: ['invites', 'orderGoods', 'browseGoods', 'jumpLink', 'collectGoods']
  },
  itemIds: {
    list: ['orderGoods', 'browseGoods', 'collectGoods']
  },
  taskRateType: {
    list: ['invites', 'orderGoods', 'browseGoods', 'collectGoods']
  },
  link: { list: ['jumpLink'] }
}

export const PASS_URL_LIST: string[] = [
  '1688.cn',
  '1688.com',
  'alibaba.cn',
  'alibaba.com',
  'aliexpress.com',
  'alimama.cn',
  'alimama.com',
  'alipay.com.cn',
  'alipay.com',
  'alipay.net',
  'aliplay.com',
  'alisoft.cn',
  'alisoft.com',
  'aliyun.com',
  'aliyun.net',
  'koubei.cn',
  'koubei.com',
  'taobao.cn',
  'taobao.com',
  'taobao.net',
  'tb.cn',
  'tmall.com',
  'zhifu.com',
  'zhifubao.com',
  'juhuasuan.com',
  'tmall.hk',
  'tmall.com.hk',
  'jiyoujia.com',
  'pailitao.com',
  'cainiao.com',
  'dingtalk.com',
  'yushanfang.com',
  'guoguo-app.com',
  'alihealth.cn',
  'miaostreet.com',
  'uc123.com',
  'uc.cn',
  'ucweb.com',
  'aliyun-inc.com',
  'cainiaoyizhan.com',
  'umeng.com',
  'aliplus.com',
  'aliplay.com',
  'taopiaopiao.com',
  'youku.com',
  'tudou.com',
  'xinlingshou.cn',
  'fliggy.com',
  'feizhu.com',
  'feizhu.cn'
]

//saas订购码 根据需求改变
export const APP_SUB_CODE: string = 'FW_GOODS-1001086450'

export const TEMPLATE_INFO = {
  clients: 'taobao,tmall',
  template_id: 3000000002590532,
  template_version: '0.0.3'
}

//物流状态
export const SHIP_STATUS = {
  NO_ADDRESS: 1,
  NO_SHIP: 2,
  HAS_SHIP: 3
}

export const STOCK_TYPE = {
  LIMIT: 1,
  NO_LIMIT:2
}
