"use strict";
/** @format */
Object.defineProperty(exports, "__esModule", { value: true });
exports.signFigures = exports.rand = void 0;
exports.rand = (function () {
  var seed = new Date().getTime();
  function r() {
    seed = (seed * 9301 + 49297) % 233280;
    return seed / 233280.0;
  }
  return function (number) {
    return Math.ceil(r() * number);
  };
})();
exports.signFigures = function (num, rank) {
  if (rank === void 0) { rank = 6; }
  if (!num)
    return 0;
  var sign = num / Math.abs(num);
  var number = num * sign;
  var temp = rank - 1 - Math.floor(Math.log10(number));
  var ans;
  if (temp > 0) {
    ans = parseFloat(number.toFixed(temp));
  }
  else if (temp < 0) {
    ans = Math.round(number / Math.pow(10, temp)) * temp;
  }
  else {
    ans = Math.round(number);
  }
  return ans * sign;
};
// # sourceMappingURL=rand.js.map