"use strict";
/**
 * 任务相关方法
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
  var extendStatics = function (d, b) {
    extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
  };
  return function (d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
})();
var __assign = (this && this.__assign) || function () {
  __assign = Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
        t[p] = s[p];
    }
    return t;
  };
  return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
    function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
    function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
  return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
    if (f) throw new TypeError("Generator is already executing.");
    while (_) try {
      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
      if (y = 0, t) op = [op[0] & 2, t.value];
      switch (op[0]) {
        case 0: case 1: t = op; break;
        case 4: _.label++; return { value: op[1], done: false };
        case 5: _.label++; y = op[1]; op = [0]; continue;
        case 7: op = _.ops.pop(); _.trys.pop(); continue;
        default:
          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
          if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
          if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
          if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
          if (t[2]) _.ops.pop();
          _.trys.pop(); continue;
      }
      op = body.call(thisArg, _);
    } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
    if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
    for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
      r[k] = a[j];
  return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var user_service_1 = require("./user.service");
var utils_1 = require("../utils");
var constants_1 = require("../constants");
var TaskService = /** @class */ (function (_super) {
  __extends(TaskService, _super);
  function TaskService(context) {
    return _super.call(this, context) || this;
  }
  TaskService.prototype.initVipTask = function (userInfo, vipInfo, tasks) {
    var _a = userInfo.member, flag = _a.flag, newMember = _a.newMember, remainTimes = userInfo.remainTimes;
    // 后台配置奖励
    var value = tasks.beMembership.value;
    // 会员信息
    var isVipBefore = flag;
    return {
      taskType: "member",
      title: "\u52A0\u5165\u4F1A\u5458",
      url: vipInfo.url,
      rewards: value,
      waitReceive: remainTimes.member,
      // 已经是会员, 说明完成任务
      done: newMember || isVipBefore
    };
  };
  // 初始化下单任务
  TaskService.prototype.initOrderGoodsTask = function (userInfo, tasks) {
    var _a;
    var _b = tasks.orderGoods, value = _b.value, itemIds = _b.itemIds, taskRateType = _b.taskRateType, times = _b.times;
    var remainTimes = userInfo.remainTimes, taskInfo = userInfo.taskInfo;
    var orderTask = {
      taskType: "orderGoods",
      title: "\u4E0B\u5355\u5546\u54C1",
      itemIds: itemIds,
      rewards: value,
      waitReceive: remainTimes.orderGoods,
      done: false
    };
    var orderGoodsCompleteList = this.getCompleteTaskByUserTaskInfo('orderGoods', userInfo);
    // 永久任务且已完成
    if (taskRateType === constants_1.TASK_RATE_TYPE.FOREVER && orderGoodsCompleteList) {
      orderTask.done = true;
    }
    // 每日限制完成且完成次数达到限制
    var today = utils_1.getToday();
    if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && ((_a = taskInfo === null || taskInfo === void 0 ? void 0 : taskInfo[today]) === null || _a === void 0 ? void 0 : _a.orderGoods) >= times) {
      orderTask.done = true;
    }
    return orderTask;
  };
  // 初始化浏览商品任务
  TaskService.prototype.initBrowseGoodsTask = function (userInfo, tasks) {
    var _a;
    var _b = tasks.browseGoods, value = _b.value, itemIds = _b.itemIds, taskRateType = _b.taskRateType, times = _b.times;
    var remainTimes = userInfo.remainTimes, taskInfo = userInfo.taskInfo;
    var orderTask = {
      taskType: "browseGoods",
      title: "\u6D4F\u89C8\u5546\u54C1",
      itemIds: itemIds,
      rewards: value,
      waitReceive: remainTimes.browseGoods,
      done: false
    };
    var browseGoodsCompleteList = this.getCompleteTaskByUserTaskInfo('browseGoods', userInfo);
    // 永久任务且已完成
    if (taskRateType === constants_1.TASK_RATE_TYPE.FOREVER && browseGoodsCompleteList) {
      orderTask.done = true;
    }
    // 每日限制完成且完成次数达到限制
    var today = utils_1.getToday();
    if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && ((_a = taskInfo === null || taskInfo === void 0 ? void 0 : taskInfo[today]) === null || _a === void 0 ? void 0 : _a.browseGoods) >= times) {
      orderTask.done = true;
    }
    return orderTask;
  };
  // 初始化邀请任务
  TaskService.prototype.initInvitesTask = function (userInfo, tasks) {
    var _a;
    var _b = tasks.inviteFriends, value = _b.value, taskRateType = _b.taskRateType, times = _b.times;
    var remainTimes = userInfo.remainTimes, taskInfo = userInfo.taskInfo;
    var orderTask = {
      taskType: "invites",
      title: "\u9080\u8BF7",
      rewards: value,
      waitReceive: remainTimes.invites,
      done: false
    };
    var invitesCompleteList = this.getCompleteTaskByUserTaskInfo('invites', userInfo);
    // 永久任务且已完成
    if (taskRateType === constants_1.TASK_RATE_TYPE.FOREVER && invitesCompleteList) {
      orderTask.done = true;
    }
    // 每日限制完成且完成次数达到限制
    var today = utils_1.getToday();
    if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && ((_a = taskInfo === null || taskInfo === void 0 ? void 0 : taskInfo[today]) === null || _a === void 0 ? void 0 : _a.invites) >= times) {
      orderTask.done = true;
    }
    return orderTask;
  };
  // 关注店铺
  TaskService.prototype.initFollowTask = function (userInfo, tasks) {
    var value = tasks.attentionStore.value;
    var remainTimes = userInfo.remainTimes;
    var orderGoodsCompleteList = this.getCompleteTaskByUserTaskInfo('follow', userInfo);
    return {
      taskType: "follow",
      title: "\u5173\u6CE8\u5E97\u94FA",
      rewards: value,
      waitReceive: remainTimes.follow,
      done: !!orderGoodsCompleteList.length
    };
  };
  // 积分兑换
  TaskService.prototype.initExchangeCreditsTask = function (userInfo, tasks) {
    var _a;
    var _b = tasks.exchangeCredits, value = _b.value, times = _b.times;
    var remainTimes = userInfo.remainTimes, taskInfo = userInfo.taskInfo;
    var today = utils_1.getToday();
    return {
      taskType: "exchangeCredits",
      title: "\u79EF\u5206\u5151\u6362",
      rewards: value,
      waitReceive: remainTimes.exchangeCredits,
      // 积分兑换固定为每日限制
      done: !!(((_a = taskInfo === null || taskInfo === void 0 ? void 0 : taskInfo[today]) === null || _a === void 0 ? void 0 : _a.exchangeCredits) >= times)
    };
  };
  // 根据会员状态更新
  TaskService.prototype.updateVipTaskStatus = function (userInfo, vipInfo, tasks) {
    var member = userInfo.member, remainTimes = userInfo.remainTimes, _id = userInfo._id;
    var newMember = member.newMember;
    var today = utils_1.getToday();
    var isNewVip = this.checkNewVipStatus(userInfo, vipInfo);
    var value = tasks.beMembership.value;
    if (isNewVip && !newMember) {
      member.newMember = true;
      member.bememberTime = Date.now();
      member.bememberDay = today;
      remainTimes.member = (remainTimes.member || 0) + value;
    }
    return {
      member: member,
      remainTimes: remainTimes
    };
  };
  TaskService.prototype.updateOrderGoodsTask = function (userInfo, tasks, session) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
      var taskInfo, remainTimes, _b, value, itemIds, taskRateType, times, orderGoodsCompleteList, today, lastOrderInfo, orderResult, itemIdsArr;
      return __generator(this, function (_c) {
        switch (_c.label) {
          case 0:
            taskInfo = userInfo.taskInfo, remainTimes = userInfo.remainTimes;
            _b = tasks.orderGoods, value = _b.value, itemIds = _b.itemIds, taskRateType = _b.taskRateType, times = _b.times;
            orderGoodsCompleteList = this.getCompleteTaskByUserTaskInfo('orderGoods', userInfo);
            // 永久任务且已完成
            if (taskRateType === constants_1.TASK_RATE_TYPE.FOREVER && orderGoodsCompleteList) {
              return [2 /* return*/, {}];
            }
            today = utils_1.getToday();
            if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && ((_a = taskInfo === null || taskInfo === void 0 ? void 0 : taskInfo[today]) === null || _a === void 0 ? void 0 : _a.orderGoods) >= times) {
              return [2 /* return*/, {}];
            }
            lastOrderInfo = (orderGoodsCompleteList === null || orderGoodsCompleteList === void 0 ? void 0 : orderGoodsCompleteList[orderGoodsCompleteList.length - 1]) || {};
            return [4 /* yield*/, utils_1.getUserOrderlist(this.context, 
              // @ts-ignore
              lastOrderInfo.createTime || Date.now(), Date.now(), session)];
          case 1:
            orderResult = _c.sent();
            itemIdsArr = itemIds.split(',').map(function (v) { return +v; });
            orderResult.forEach(function (v) {
              if (itemIdsArr.includes(v.itemId)) {
                remainTimes.orderGoods += +value;
                taskInfo[today] = (taskInfo === null || taskInfo === void 0 ? void 0 : taskInfo[today]) || {};
                taskInfo[today].orderGoods = taskInfo[today].orderGoods || [];
                taskInfo[today].orderGoods.push({
                  itemId: v.itemId,
                  createTime: Date.now()
                });
              }
            });
            return [2 /* return*/, {
              remainTimes: remainTimes,
              taskInfo: taskInfo
            }];
        }
      });
    });
  };
  /**
     *更新关注店铺任务状态
     *
     * @param {IUserInfo} userInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof TaskService
     */
  TaskService.prototype.updateFollowTask = function (userInfo, activityInfo) {
    return __awaiter(this, void 0, void 0, function () {
      var today, remainTimes, _id, taskInfo, follow, tasks, value, followInfo;
      return __generator(this, function (_a) {
        switch (_a.label) {
          case 0:
            today = utils_1.getToday();
            remainTimes = userInfo.remainTimes, _id = userInfo._id, taskInfo = userInfo.taskInfo, follow = userInfo.follow;
            tasks = activityInfo.tasks;
            value = (tasks || {}).attentionStore.value;
            followInfo = __assign(__assign({}, follow), { newFollow: true, followTime: Date.now(), followDay: today });
            // 记录数据
            taskInfo[today] = taskInfo[today] || {};
            taskInfo[today].follow = 1;
            // 增加待领取次数
            remainTimes.follow += value;
            return [4 /* yield*/, this.updateUser(_id, {
              $set: {
                remainTimes: remainTimes,
                follow: followInfo,
                taskInfo: taskInfo
              }
            })];
          case 1: return [2 /* return*/, _a.sent()];
        }
      });
    });
  };
  /**
     *
     * 获取任务今天完成的次数
     *
     * @param {string} taskType  任务类型
     * @param {IUserInfo} userInfo 用户信息
     * @returns {number} todayTimes  今日任务完成次数  todayTaskInfo  今日对应任务完成详情
     * @memberof TaskService
     */
  TaskService.prototype.getTodayCompleteTask = function (taskType, userInfo) {
    var _a, _b, _c, _d, _e;
    var today = utils_1.getToday();
    return {
      todayTimes: ((_c = (_b = (_a = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _a === void 0 ? void 0 : _a[today]) === null || _b === void 0 ? void 0 : _b[taskType]) === null || _c === void 0 ? void 0 : _c.length) || 0,
      todayTaskInfo: (_e = (_d = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _d === void 0 ? void 0 : _d[today]) === null || _e === void 0 ? void 0 : _e[taskType]
    };
  };
  /**
     * 根据任务类型获取任务完成情况
     *
     * @param {IUserInfo} userInfo
     * @param {string} taskType
     * @returns {array}
     * @memberof TaskService
     */
  TaskService.prototype.getCompleteTaskByUserTaskInfo = function (taskType, userInfo) {
    var _a = userInfo.taskInfo, taskInfo = _a === void 0 ? {} : _a;
    var targetTaskList = [];
    Object.keys(taskInfo).forEach(function (day) {
      var _a, _b, _c, _d;
      if ((_a = taskInfo[day]) === null || _a === void 0 ? void 0 : _a[taskType]) {
        var dayTaskInfo = Array.isArray((_b = taskInfo[day]) === null || _b === void 0 ? void 0 : _b[taskType])
          ? (_c = taskInfo[day]) === null || _c === void 0 ? void 0 : _c[taskType] : [(_d = taskInfo[day]) === null || _d === void 0 ? void 0 : _d[taskType]];
        targetTaskList = __spreadArrays(targetTaskList, dayTaskInfo);
      }
    });
    return targetTaskList;
  };
  /**
     *根据任务类型更新任务待领取次数和任务记录
     *
     * @param {string} taskType
     * @param {number} rewards
     * @param {IUserInfo} userInfo
     * @param {object} [customRecord]
     * @returns {boolean}
     * @memberof TaskService
     */
  TaskService.prototype.updateUserTaskRecord = function (taskType, rewards, userInfo, customRecord) {
    return __awaiter(this, void 0, void 0, function () {
      var _id, openId, today, result;
      var _a, _b;
      return __generator(this, function (_c) {
        switch (_c.label) {
          case 0:
            _id = userInfo._id;
            openId = this.context.openId;
            today = utils_1.getToday();
            return [4 /* yield*/, this.updateUser(_id, {
              $inc: (_a = {},
              _a["remainTimes." + taskType] = rewards,
              _a),
              $push: (_b = {},
              _b["taskInfo." + today + "." + taskType] = __assign({ openId: openId, createTime: Date.now() }, customRecord),
              _b)
            })];
          case 1:
            result = _c.sent();
            return [2 /* return*/, result === 1];
        }
      });
    });
  };
  TaskService.prototype.updateTasks = function (id, needUpdateKeysArray) {
    return __awaiter(this, void 0, void 0, function () {
      var updateKeys;
      return __generator(this, function (_a) {
        switch (_a.label) {
          case 0:
            updateKeys = Object.assign.apply(Object, __spreadArrays([{}], needUpdateKeysArray));
            return [4 /* yield*/, this.updateUser(id, {
              $set: updateKeys
            })];
          case 1:
            _a.sent();
            return [4 /* yield*/, this.getUserInfo()];
          case 2: return [2 /* return*/, _a.sent()];
        }
      });
    });
  };
  return TaskService;
}(user_service_1.default));
exports.default = TaskService;
// # sourceMappingURL=task.service.js.map