"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../sdk");
var db_1 = require("../db");
var constants_1 = require("../constants");
var utils_1 = require("../utils");
var ActivityConfigService = /** @class */ (function () {
    function ActivityConfigService(context) {
        this.activityconfigDao = new sdk_1.BaseDao(context, db_1.ACTIVITY_CONFIG_DB_NAME);
        this.activityconfigPrizeDao = new sdk_1.BaseDao(context, db_1.PRIZE_CONFIG_DB_NAME);
    }
    //保存新建活动
    ActivityConfigService.prototype.saveNewActivity = function (baseConfig, prize, openId) {
        return __awaiter(this, void 0, void 0, function () {
            var result_1, e_1, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 7, , 8]);
                        return [4 /*yield*/, this.activityconfigDao.insertOne(__assign(__assign({}, baseConfig), { createTime: Date.now(), updateTime: Date.now(), deleteStatus: constants_1.DELETE_STATUS.EXIST, openPrizeStatus: constants_1.OPEN_PRIZE_STATUS.WAIT_AWARD }))];
                    case 1:
                        result_1 = _a.sent();
                        console.log(result_1, '保存基础配置result');
                        if (!result_1) return [3 /*break*/, 6];
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 6]);
                        prize = prize.map(function (item) {
                            return __assign(__assign({}, item), { activityId: result_1, openId: openId, createTime: Date.now(), updateTime: Date.now(), deleteStatus: constants_1.DELETE_STATUS.EXIST });
                        });
                        return [4 /*yield*/, this.activityconfigPrizeDao.insertMany(prize)];
                    case 3: return [2 /*return*/, _a.sent()];
                    case 4:
                        e_1 = _a.sent();
                        console.log(e_1, '保存奖品配置出错');
                        // 如果奖品未保存删除之前的活动
                        return [4 /*yield*/, this.activityconfigDao.delete({
                                _id: result_1
                            })];
                    case 5:
                        // 如果奖品未保存删除之前的活动
                        _a.sent();
                        return [3 /*break*/, 6];
                    case 6: return [3 /*break*/, 8];
                    case 7:
                        e_2 = _a.sent();
                        //保存活动失败
                        console.log(e_2, '保存活动失败');
                        return [3 /*break*/, 8];
                    case 8: return [2 /*return*/];
                }
            });
        });
    };
    // 更新活动基本信息
    ActivityConfigService.prototype.updateBaseConfigInfo = function (id, data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigDao.update({ _id: id }, {
                            $set: __assign(__assign({}, data), { updateTime: Date.now(), deleteStatus: constants_1.DELETE_STATUS.EXIST })
                        })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    // 通过id获取奖品信息
    ActivityConfigService.prototype.getPrizeInfoById = function (id) {
        return __awaiter(this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigPrizeDao.find({
                            _id: id
                        })];
                    case 1:
                        result = _a.sent();
                        if (result && result[0]) {
                            return [2 /*return*/, result[0]];
                        }
                        return [2 /*return*/, false];
                }
            });
        });
    };
    // 奖品置为删除状态
    ActivityConfigService.prototype.updateDeleteStatusById = function (id) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigPrizeDao.update({
                            _id: id
                        }, {
                            $set: {
                                deleteStatus: constants_1.DELETE_STATUS.DELETE
                            }
                        })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    ActivityConfigService.prototype.deletePrizeByIds = function (ids) {
        return __awaiter(this, void 0, void 0, function () {
            var result, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        result = true;
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < ids.length)) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.updateDeleteStatusById(ids[i])];
                    case 2:
                        result = _a.sent();
                        _a.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/, result];
                }
            });
        });
    };
    ActivityConfigService.prototype.insertAndUpdatePrize = function (activityId, allPrizeList, bothIds) {
        return __awaiter(this, void 0, void 0, function () {
            var result, i, isNewPrize, insertResult, isEditPrize, editResult;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        result = {
                            success: [],
                            failed: []
                        };
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < allPrizeList.length)) return [3 /*break*/, 6];
                        isNewPrize = !allPrizeList[i]._id;
                        if (!isNewPrize) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.insertPrizeByActivityId(activityId, allPrizeList[i])];
                    case 2:
                        insertResult = _a.sent();
                        if (insertResult) {
                            result.success.push(insertResult);
                        }
                        else {
                            result.failed.push(insertResult);
                        }
                        _a.label = 3;
                    case 3:
                        isEditPrize = bothIds.includes(allPrizeList[i]._id);
                        if (!isEditPrize) return [3 /*break*/, 5];
                        if (allPrizeList[i].switchStock === constants_1.STOCK_TYPE.NO_LIMIT) {
                            allPrizeList[i].useStock = 0;
                        }
                        else if (allPrizeList[i].switchStock === constants_1.STOCK_TYPE.LIMIT) {
                            ;
                            (allPrizeList[i].useStock || allPrizeList[i].useStock === 0) && delete allPrizeList[i].useStock;
                        }
                        return [4 /*yield*/, this.updateOnePrizeById(allPrizeList[i]._id, allPrizeList[i])];
                    case 4:
                        editResult = _a.sent();
                        if (editResult) {
                            result.success.push(editResult);
                        }
                        else {
                            result.failed.push(editResult);
                        }
                        _a.label = 5;
                    case 5:
                        i++;
                        return [3 /*break*/, 1];
                    case 6: return [2 /*return*/, result];
                }
            });
        });
    };
    // 更新单条数据
    ActivityConfigService.prototype.updateOnePrizeById = function (id, data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (data.switchStock === constants_1.STOCK_TYPE.NO_LIMIT) {
                            data.useStock = 0;
                        }
                        else {
                            delete data.useStock;
                        }
                        return [4 /*yield*/, this.activityconfigPrizeDao.update({
                                _id: id
                            }, {
                                $set: __assign(__assign({}, data), { updateTime: Date.now(), deleteStatus: constants_1.DELETE_STATUS.EXIST })
                            })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    // 插入单条奖品数据
    ActivityConfigService.prototype.insertPrizeByActivityId = function (activityId, data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigPrizeDao.insertOne(__assign(__assign({}, data), { activityId: activityId, useStock: 0, createTime: Date.now(), updateTime: Date.now(), deleteStatus: constants_1.DELETE_STATUS.EXIST }))];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    // 获取奖品所有配置
    ActivityConfigService.prototype.getAllOldPrizeList = function (activityId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigPrizeDao.find({ activityId: activityId })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    // 编辑活动时, 对比新旧奖品配置, 找出删除的id和更新的id
    ActivityConfigService.prototype.diffPrizeList = function (activityId, pirzeList) {
        return __awaiter(this, void 0, void 0, function () {
            function getIds(pirzeList) {
                return pirzeList.reduce(function (s, v) {
                    if (v._id) {
                        s = __spreadArrays(s, [v._id]);
                    }
                    return s;
                }, []);
            }
            var allNewIds, oldPrizeList, oldIds, deleteIds, bothIds;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        allNewIds = getIds(pirzeList);
                        return [4 /*yield*/, this.getAllOldPrizeList(activityId)];
                    case 1:
                        oldPrizeList = _a.sent();
                        oldIds = getIds(oldPrizeList);
                        deleteIds = [];
                        bothIds = oldIds.reduce(function (s, i) {
                            if (allNewIds.includes(i)) {
                                s = __spreadArrays(s, [i]);
                            }
                            else {
                                deleteIds.push(i);
                            }
                            return s;
                        }, []);
                        return [2 /*return*/, {
                                deleteIds: deleteIds,
                                bothIds: bothIds
                            }];
                }
            });
        });
    };
    //更新活动配置
    ActivityConfigService.prototype.updateActivity = function (activityId, data, prizeNoId) {
        return __awaiter(this, void 0, void 0, function () {
            var originalData, result, prizeOldIdsByActivity, prizeResult, deleteOldPrizeList, e_3, e_4;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        console.log(activityId, data, prizeNoId, 'activityId, data, prizeNoId, oldPrizeIds');
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 12, , 13]);
                        return [4 /*yield*/, this.activityconfigDao.findOne({
                                _id: activityId
                            })];
                    case 2:
                        originalData = _a.sent();
                        return [4 /*yield*/, this.activityconfigDao.update({
                                _id: activityId
                            }, {
                                $set: __assign(__assign({}, data), { createTime: originalData.createTime, updateTime: Date.now() })
                            })];
                    case 3:
                        result = _a.sent();
                        if (!result) return [3 /*break*/, 11];
                        _a.label = 4;
                    case 4:
                        _a.trys.push([4, 9, , 11]);
                        return [4 /*yield*/, this.activityconfigPrizeDao.find({
                                activityId: activityId
                            })];
                    case 5:
                        prizeOldIdsByActivity = (_a.sent()).reduce(function (s, v) {
                            return (s = __spreadArrays(s, [v._id]));
                        }, []);
                        return [4 /*yield*/, this.activityconfigPrizeDao.insertMany(prizeNoId)];
                    case 6:
                        prizeResult = _a.sent();
                        if (!prizeResult) return [3 /*break*/, 8];
                        deleteOldPrizeList = prizeOldIdsByActivity.reduce(function (s, item) {
                            return (s = __spreadArrays(s, [
                                _this.activityconfigPrizeDao.delete({
                                    _id: item
                                })
                            ]));
                        }, []);
                        return [4 /*yield*/, Promise.all(deleteOldPrizeList)];
                    case 7: return [2 /*return*/, _a.sent()];
                    case 8: return [3 /*break*/, 11];
                    case 9:
                        e_3 = _a.sent();
                        return [4 /*yield*/, this.activityconfigDao.update({
                                _id: activityId
                            }, {
                                $set: __assign({}, originalData[0])
                            })];
                    case 10:
                        _a.sent();
                        return [3 /*break*/, 11];
                    case 11: return [3 /*break*/, 13];
                    case 12:
                        e_4 = _a.sent();
                        return [3 /*break*/, 13];
                    case 13: return [2 /*return*/];
                }
            });
        });
    };
    //通过openId去获取当前商家活动列表
    ActivityConfigService.prototype.getActivityListByOpenId = function (openId, _a) {
        var _b = _a.pageSize, pageSize = _b === void 0 ? 10 : _b, _c = _a.pageNo, pageNo = _c === void 0 ? 1 : _c;
        return __awaiter(this, void 0, void 0, function () {
            var _d;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        _d = {};
                        return [4 /*yield*/, this.activityconfigDao.find({
                                openId: openId,
                                deleteStatus: constants_1.DELETE_STATUS.EXIST
                            }, {
                                projection: {
                                    startTime: 1,
                                    endTime: 1,
                                    title: 1
                                },
                                sort: {
                                    createTime: -1
                                },
                                limit: pageSize,
                                skip: (pageNo - 1) * pageSize
                            })];
                    case 1:
                        _d.list = _e.sent();
                        return [4 /*yield*/, this.activityconfigDao.count({
                                openId: openId,
                                deleteStatus: constants_1.DELETE_STATUS.EXIST
                            })];
                    case 2: return [2 /*return*/, (_d.total = _e.sent(),
                            _d.pageSize = pageSize,
                            _d.pageNo = pageNo,
                            _d)];
                }
            });
        });
    };
    //通过activityId去获取活动配置信息
    ActivityConfigService.prototype.getActivityInfoByActivityId = function (activityId) {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = {};
                        return [4 /*yield*/, this.activityconfigDao.findOne({
                                _id: activityId,
                                deleteStatus: constants_1.DELETE_STATUS.EXIST
                            })];
                    case 1:
                        _a.baseConfig = _b.sent();
                        return [4 /*yield*/, this.activityconfigPrizeDao.find({ activityId: activityId, deleteStatus: constants_1.DELETE_STATUS.EXIST, type: { $ne: constants_1.PRIZE_TYPE.THANK } }, { sort: { level: 1 } })];
                    case 2: return [2 /*return*/, (_a.prizeConfig = _b.sent(),
                            _a)];
                }
            });
        });
    };
    //通过activityId去删除活动
    ActivityConfigService.prototype.deleteActivityByActivityId = function (activityId) {
        return __awaiter(this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigDao.update({ _id: activityId }, { $set: { deleteStatus: constants_1.DELETE_STATUS.DELETE } })
                        // 删除活动奖品配置
                    ];
                    case 1:
                        result = _a.sent();
                        if (!result) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.activityconfigPrizeDao.update({ activityId: activityId }, { $set: { deleteStatus: constants_1.DELETE_STATUS.DELETE } })];
                    case 2: return [2 /*return*/, _a.sent()];
                    case 3: return [2 /*return*/, false];
                }
            });
        });
    };
    // 查询待开奖列表
    ActivityConfigService.prototype.getNodifyList = function (serverTime) {
        return __awaiter(this, void 0, void 0, function () {
            var list;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityconfigDao.find({
                            endTime: {
                                $lt: serverTime
                            },
                            openPrizeStatus: {
                                $in: [constants_1.OPEN_PRIZE_STATUS.WAIT_AWARD, constants_1.OPEN_PRIZE_STATUS.FAIL]
                            },
                            deleteStatus: constants_1.DELETE_STATUS.EXIST
                        })];
                    case 1:
                        list = _a.sent();
                        console.log(list);
                        return [2 /*return*/, list];
                }
            });
        });
    };
    // 更新openPrizeStatus为处理中
    ActivityConfigService.prototype.update2Process = function (_id) {
        return __awaiter(this, void 0, void 0, function () {
            var e_5;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.activityconfigDao.update({
                                _id: _id
                            }, {
                                $set: {
                                    openPrizeStatus: constants_1.OPEN_PRIZE_STATUS.PROCESSING,
                                    updateTime: Date.now()
                                }
                            })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, true];
                    case 2:
                        e_5 = _a.sent();
                        // 日志记录
                        console.log(e_5);
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    // 更新openPrizeStatus为成功
    ActivityConfigService.prototype.update2Success = function (_id) {
        return __awaiter(this, void 0, void 0, function () {
            var e_6;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.activityconfigDao.update({
                                _id: _id
                            }, {
                                $set: {
                                    openPrizeStatus: constants_1.OPEN_PRIZE_STATUS.SUCCESS,
                                    openPrizeMsg: '',
                                    updateTime: Date.now()
                                }
                            })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, true];
                    case 2:
                        e_6 = _a.sent();
                        // 日志记录
                        console.log(e_6);
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    // 更新openPrizeStatus为失败
    ActivityConfigService.prototype.update2Fail = function (_id, message) {
        return __awaiter(this, void 0, void 0, function () {
            var e_7;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.activityconfigDao.update({
                                _id: _id
                            }, {
                                $set: {
                                    openPrizeStatus: constants_1.OPEN_PRIZE_STATUS.FAIL,
                                    openPrizeMsg: message || '',
                                    updateTime: Date.now()
                                }
                            })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, true];
                    case 2:
                        e_7 = _a.sent();
                        // 日志记录
                        console.log(e_7);
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 组装奖品数据
     *
     * @param {Array<IActivityPrize>} prizeConfig
     * @returns
     * @memberof ActivityConfigService
     */
    ActivityConfigService.prototype.formatPrizeConfig = function (prizeConfig) {
        // level 根据level排序
        var prizeList = prizeConfig.sort(function (a, b) { return a.level - b.level; });
        // 风驰台 ejs渲染
        var poolConfig = [
            { conditionKeys: [], name: '抽卡规则', key: 'RateTable', sort: 'prizePool', prizeDataType: 6, customizeId: 6 },
            {
                conditionKeys: [{ key: 'needCards', value: '3' }],
                name: '解锁1张卡牌出奖规则',
                prizeDataType: 7,
                key: 'RatePrizePool2',
                sort: 'prizePool',
                customizeId: 7
            },
            {
                conditionKeys: [{ key: 'needCards', value: '5' }],
                name: '解锁2张卡牌出奖规则',
                prizeDataType: 7,
                key: 'RatePrizePool3',
                sort: 'prizePool',
                customizeId: 8
            },
            {
                conditionKeys: [{ key: 'needCards', value: '7' }],
                name: '解锁3张卡牌出奖规则',
                prizeDataType: 7,
                key: 'RatePrizePool4',
                sort: 'prizePool',
                customizeId: 9
            },
            {
                conditionKeys: [{ key: 'needTimes', value: '6' }],
                name: '累计抽卡1次出奖规则',
                prizeDataType: 8,
                key: 'RatePrizePool5',
                sort: 'prizePool',
                customizeId: 10
            },
            {
                conditionKeys: [{ key: 'needTimes', value: '10' }],
                name: '累计抽卡2次出奖规则',
                prizeDataType: 8,
                key: 'RatePrizePool6',
                sort: 'prizePool',
                customizeId: 11
            },
            {
                conditionKeys: [{ key: 'needTimes', value: '15' }],
                name: '累计抽卡3次出奖规则',
                prizeDataType: 8,
                key: 'RatePrizePool7',
                sort: 'prizePool',
                customizeId: 12
            },
            {
                conditionKeys: [{ key: 'needTimes', value: '20' }],
                name: '累计抽卡4次出奖规则',
                prizeDataType: 8,
                key: 'RatePrizePool8',
                sort: 'prizePool',
                customizeId: 13
            },
            {
                conditionKeys: [],
                name: '助力奖品',
                key: 'RatePrizePool9',
                sort: 'prizePool',
                prizeDataType: 9,
                customizeId: 14
            }
        ];
        // 取出奖池
        var prizeData = {};
        poolConfig.forEach(function (item) {
            if ((item === null || item === void 0 ? void 0 : item.sort) == 'prizePool') {
                prizeData[item.key] = prizeList.filter(function (prize) {
                    return +item.prizeDataType == +prize.prizeDataType;
                });
            }
        });
        // 过滤奖池条件
        poolConfig.forEach(function (item) {
            var _a;
            if ((item === null || item === void 0 ? void 0 : item.sort) == 'prizePool') {
                if ((_a = item.conditionKeys) === null || _a === void 0 ? void 0 : _a.length) {
                    item.conditionKeys.forEach(function (condition) {
                        prizeData[item.key] = prizeData[item.key].filter(function (prize) {
                            return prize[condition.key] == condition.value;
                        });
                    });
                }
            }
        });
        return prizeData;
    };
    // 概率奖品配置 properiodfrom  properiodto
    ActivityConfigService.prototype.setPrizeProbalityRange = function (prizes) {
        var originPeriod = 1;
        return prizes.map(function (v) {
            if (!v.probability)
                return v;
            // 概率为0 跳出10000之外的区间
            if (+v.probability === 0)
                return __assign(__assign({}, v), { properiodfrom: 1000000, properiodto: 1000000 });
            var properiodfrom = originPeriod;
            var properiodto = +originPeriod + utils_1.signFigures(+v.probability * 100) - 1;
            originPeriod = +originPeriod + utils_1.signFigures(+v.probability * 100);
            return __assign(__assign({}, v), { properiodfrom: properiodfrom,
                properiodto: properiodto });
        });
    };
    return ActivityConfigService;
}());
exports.default = ActivityConfigService;
//# sourceMappingURL=activityconfig.service.js.map