"use strict";
/** @format */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var service_1 = require("../service");
var index_1 = require("../utils/index");
var xlsx = require("node-xlsx");
var BaseController = /** @class */ (function () {
    function BaseController() {
    }
    /**
     *  活动中奖名单
     */
    BaseController.prototype.findWinnerInfoList = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var _c, _d, activityId, _e, prizeId, _f, userNick, _g, shipStatus, _h, prizeType, _j, prizeDataType, _k, pageNo, _l, pageSize, startTime, endTime, awardList;
            return __generator(this, function (_m) {
                switch (_m.label) {
                    case 0:
                        _c = context.data, _d = _c.activityId, activityId = _d === void 0 ? '' : _d, _e = _c.prizeId, prizeId = _e === void 0 ? null : _e, _f = _c.userNick, userNick = _f === void 0 ? '' : _f, _g = _c.shipStatus, shipStatus = _g === void 0 ? null : _g, _h = _c.prizeType, prizeType = _h === void 0 ? null : _h, _j = _c.prizeDataType, prizeDataType = _j === void 0 ? null : _j, _k = _c.pageNo, pageNo = _k === void 0 ? 1 : _k, _l = _c.pageSize, pageSize = _l === void 0 ? 10 : _l, startTime = _c.startTime, endTime = _c.endTime;
                        return [4 /*yield*/, awardsService.getAwardListByActivityId({
                                activityId: activityId,
                                prizeId: prizeId,
                                userNick: userNick,
                                shipStatus: shipStatus,
                                type: prizeType,
                                prizeDataType: prizeDataType,
                                pageNo: pageNo,
                                pageSize: pageSize,
                                startTime: startTime,
                                endTime: endTime
                            })];
                    case 1:
                        awardList = _m.sent();
                        console.log("awardList: " + JSON.stringify(awardList));
                        return [2 /*return*/, sdk_1.resultsModel.success(awardList)];
                }
            });
        });
    };
    //获取活动中奖名单 为导出做准备
    BaseController.prototype.getAwardsList = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, _c, activityId, title, prizeId, userNick, startTime, endTime, shipStatus, prizeType, prizeDataType, pageNo, pageSize, awardList;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        cloud = context.cloud;
                        _c = context.data, activityId = _c.activityId, title = _c.title, prizeId = _c.prizeId, userNick = _c.userNick, startTime = _c.startTime, endTime = _c.endTime, shipStatus = _c.shipStatus, prizeType = _c.prizeType, prizeDataType = _c.prizeDataType, pageNo = _c.pageNo, pageSize = _c.pageSize;
                        return [4 /*yield*/, awardsService.getAwardListByActivityId({
                                activityId: activityId,
                                title: title,
                                prizeId: prizeId,
                                userNick: userNick,
                                startTime: startTime,
                                endTime: endTime,
                                shipStatus: shipStatus,
                                type: prizeType,
                                prizeDataType: prizeDataType,
                                pageNo: pageNo,
                                pageSize: pageSize,
                                isExport: true
                            })];
                    case 1:
                        awardList = _d.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(awardList)];
                }
            });
        });
    };
    /**
     *  导出活动中奖名单
     */
    BaseController.prototype.exportAwardsList = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, title, res, _c, success, data, message, _d, _e, awwardList, total, _f, success_1, data_1, message_1, _g, awwardList_1, xlsxData, buffer, result;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        cloud = context.cloud;
                        title = context.data.title;
                        res = [];
                        return [4 /*yield*/, this.getAwardsList(context, { session: session }, [awardsService])];
                    case 1:
                        _c = _h.sent(), success = _c.success, data = _c.data, message = _c.message;
                        _d = data || {}, _e = _d.list, awwardList = _e === void 0 ? [] : _e, total = _d.total;
                        res = __spreadArrays(res, awwardList);
                        _h.label = 2;
                    case 2:
                        if (!(total > res.length)) return [3 /*break*/, 4];
                        context.data.pageNo++;
                        return [4 /*yield*/, this.getAwardsList(context, { session: session }, [awardsService])];
                    case 3:
                        _f = _h.sent(), success_1 = _f.success, data_1 = _f.data, message_1 = _f.message;
                        _g = (data_1 || {}).list, awwardList_1 = _g === void 0 ? [] : _g;
                        if (success_1) {
                            res = __spreadArrays(res, awwardList_1);
                        }
                        else {
                        }
                        return [3 /*break*/, 2];
                    case 4:
                        xlsxData = [
                            [
                                '奖品编号',
                                '用户id',
                                '中奖时间',
                                '地址填写时间',
                                '奖品类型',
                                '发奖来源',
                                '奖品名称',
                                '收货人',
                                '联系方式',
                                '收货地址'
                                // '发货状态',
                                // '物流公司',
                                // '物流单号'
                            ]
                        ];
                        res.forEach(function (v, index, arr) {
                            var prizeDataType = '/';
                            var prizeType = '/';
                            var shipTxt = '/';
                            if (v) {
                                if (v.prizeDataType == 8)
                                    prizeDataType = '累计抽奖';
                                if (v.prizeDataType == 7)
                                    prizeDataType = '阶梯抽奖';
                                if (v.prizeDataType == 9)
                                    prizeDataType = '邀请助力抽奖';
                                if (v.type == constants_1.PRIZE_TYPE.EQUITY)
                                    prizeType = '优惠券';
                                if (v.type == constants_1.PRIZE_TYPE.CREDITS)
                                    prizeType = '积分';
                                if (v.type == constants_1.PRIZE_TYPE.OBJECT) {
                                    prizeType = '实物';
                                    if (+v.shipStatus == constants_1.SHIP_STATUS.NO_ADDRESS)
                                        shipTxt = '未填写地址';
                                    if (+v.shipStatus == constants_1.SHIP_STATUS.NO_SHIP)
                                        shipTxt = '未发货';
                                    if (+v.shipStatus == constants_1.SHIP_STATUS.HAS_SHIP)
                                        shipTxt = '已发货';
                                }
                                if (v.type == constants_1.PRIZE_TYPE.THANK)
                                    prizeType = '谢谢参与';
                            }
                            xlsxData.push([
                                v._id,
                                v.userNick,
                                v.createTime ? index_1.formatTime(new Date(v.createTime + constants_1.EIGHT_HOURS)) : '',
                                v.type == 3 ? (v.receiveTime ? index_1.formatTime(new Date(v.receiveTime + constants_1.EIGHT_HOURS)) : '暂未填写') : '/',
                                prizeType,
                                prizeDataType,
                                v.type == 2 ? (v.credits || 0) + "\u79EF\u5206" : v.name || '',
                                v.type == 3 ? v.receiveName || '' : '/',
                                v.type == 3 ? (v.phone ? v.phone + '' : '暂未填写') : '/',
                                v.type == 3 ? v.province + v.city + v.area + v.streetName + v.addressDetail || '暂未填写' : '/'
                                // shipTxt,
                                // v.type == 3 ? v.shipCompany || '' : '/',
                                // v.type == 3 ? (v.shipNum ? v.shipNum + '' : '') : '/'
                            ]);
                        });
                        buffer = xlsx.build([
                            {
                                name: title + new Date().getTime(),
                                data: xlsxData
                            }
                        ]);
                        console.log("xlsxData: " + JSON.stringify(xlsxData));
                        return [4 /*yield*/, cloud.file.uploadFile({
                                fileContent: buffer,
                                fileName: title + new Date().getTime() + '.xlsx'
                            })
                            // result.url 需进行处理
                        ];
                    case 5:
                        result = _h.sent();
                        // result.url 需进行处理
                        if (result.url) {
                            result.url = result.url.replace('http', 'https').replace('-internal', '');
                        }
                        return [2 /*return*/, sdk_1.resultsModel.success(result)];
                }
            });
        });
    };
    /**
     *  导入发货
     */
    BaseController.prototype.downloadFile = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, _c, activityId, fileName, total, result, _d, sheets, data, i, prizeId, shipCompany, shipNum, result2;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        cloud = context.cloud;
                        _c = context.data, activityId = _c.activityId, fileName = _c.fileName;
                        total = 0;
                        _e.label = 1;
                    case 1:
                        _e.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, cloud.file.downloadFile({ fileId: fileName })];
                    case 2:
                        result = _e.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        _d = _e.sent();
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, 'fileId错误')];
                    case 4:
                        sheets = xlsx.parse(result);
                        console.log(sheets, 'sheets-------');
                        data = sheets[0].data;
                        console.log(JSON.stringify(data), 'data----------');
                        if (!(!data[1] || data[1].length !== 0)) return [3 /*break*/, 11];
                        if (!(data[1].length <= 3)) return [3 /*break*/, 9];
                        i = 1;
                        _e.label = 5;
                    case 5:
                        if (!(i < data.length)) return [3 /*break*/, 8];
                        prizeId = data[i][0];
                        shipCompany = data[i][1];
                        shipNum = data[i][2];
                        return [4 /*yield*/, awardsService.setUserShipStatus(activityId, prizeId, shipCompany, shipNum)];
                    case 6:
                        result2 = _e.sent();
                        total += result2;
                        _e.label = 7;
                    case 7:
                        i++;
                        return [3 /*break*/, 5];
                    case 8:
                        console.log(total, data, 'total,data');
                        return [2 /*return*/, sdk_1.resultsModel.success({ total: total, data: data })];
                    case 9:
                        console.log(data[1].length, 'length');
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '导入文件格式错误')];
                    case 10: return [3 /*break*/, 12];
                    case 11: return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '导入文件出现错误')];
                    case 12: return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "findWinnerInfoList", null);
    __decorate([
        decorator_1.paramsCheck(['activityId', 'title']),
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "getAwardsList", null);
    __decorate([
        decorator_1.paramsCheck(['title']),
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "exportAwardsList", null);
    __decorate([
        decorator_1.paramsCheck(['activityId', 'fileName']),
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "downloadFile", null);
    return BaseController;
}());
exports.default = BaseController;
//# sourceMappingURL=awards.controller.js.map