/** @format */
import { getToday } from '../getToday'

// login接口使用 当天第一次登陆有数据变更的时候使用
// updateFirstLoginToday({ $inc: { gameTime: 3}})
export default function updateUserInfo(update?: IPreUpdateQuery) {
  return async function (
    context: IContext<IParams>,
    { userInfo }: IControllerInfos
  ): Promise<IPreUpdateQuery | undefined> {
    if (!userInfo) return {}
    return update
  }
}

export function reduceGameTimes(needGameTimes: number) {
  return updateUserInfo({
    $where: `this.gameTimes >= ${needGameTimes}`,
    $inc: { gameTimes: -needGameTimes }
  })
}

export function reduceCardGameTimes(needGameTimes: number) {
  return async function (
    context: IContext<IParams>,
    { userInfo }: IControllerInfos
  ): Promise<IPreUpdateQuery | undefined> {
    if (!userInfo) return {}
    let projection: IPreUpdateQuery = { $inc: {} }
    const today = getToday()
    const { gameTimes, gameTimesEverday } = userInfo

    if (gameTimesEverday?.[today]) {
      projection.$inc[`gameTimesEverday.${today}`] = -needGameTimes
      projection.$where[`this.gameTimesEverday.${today} >= ${needGameTimes}`] = -needGameTimes
      return projection
    }

    if (gameTimes) {
      projection.$inc[`gameTimes`] = -needGameTimes
      projection.$where[`this.gameTimes >= ${needGameTimes}`] = -needGameTimes
      return projection
    }
  }
}
