/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { getToday } from '../getToday'

export default async function checkCardGameTimes(context: IContext<IParams>, { userInfo }: IControllerInfos) {
  const { gameTimes, gameTimesEverday } = userInfo
  const today = getToday()
  if (!gameTimesEverday?.[today] && !gameTimes) {
    return resultsModel.error(CODE_TYPES.ERROR_NO_GAME_TIMES)
  }
}
