/** @format */

import { FREE_TYPE } from './constants'
import { getToday } from './utils'

// login初始化用户信息
export const initCustomUserWhenLogin = (context: IContext<IParams>, activityInfo: IActivityInfo): ICustomUserInfo => {
  const { freeTimes, freeType } = activityInfo?.collectCardConfig || {}
  return {
    gameTimes: freeType === FREE_TYPE.FOERVER ? freeTimes : 0,
    gameTimesEverday: {
      [getToday()]: freeType === FREE_TYPE.EVERY_DAY ? freeTimes : 0
    },
    joinedTimes: 0,
    cardsCollectedCount: 0,
    cardInfo: {}
  }
}

export const updateUserWhenLogin = (
  context: IContext<IParams>,
  activityInfo: IActivityInfo,
  userInfo: IUserInfo
): IUpdateQuery => {
  const { freeTimes, freeType } = activityInfo?.collectCardConfig || {}
  const today = getToday()

  let projection: IUpdateQuery = {
    $inc: {}
  }

  const firstLoginToday = !userInfo?.login?.[today]

  if (firstLoginToday && freeType === FREE_TYPE.EVERY_DAY) {
    projection.$inc[`gameTimesEverday.${today}`] = freeTimes
  }
  return projection
}
