const {
  cloud
} = getApp();

import { requestType, cloudFnName } from '../config';

const request = (url, method, params, ext = {}) => {
  const {
    isShowLoading
  } = ext;
  const hideMyLoading = () => {
    if (isShowLoading) {
      my.hideLoading();
    }
  };
  if (isShowLoading) {
    my.showLoading();
  }

  const requestAms = () => {
    return my.request({
      url: `https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=${cloudFnName}.${url}`,
      method,
      data: params,
      dataType: 'json'
    }).then(res => {
      hideMyLoading();
      return res.data;
    }).catch(() => {
      hideMyLoading();
    });
  };

  const requestCloud = () => {
    return cloud.function.invoke(cloudFnName, params, url).then(res => {
      hideMyLoading();
      return res;
    }).catch(() => {
      hideMyLoading();
    });
  };

  return requestType === 'ams' ? requestAms() : requestCloud();
};

export default request;