const { cloud } = getApp();
import routerInit from 'miniapp-router';
import routerConfig, { basePath } from '../../router/index';
import { sellerSave } from '/api';

Page({
  data: {
    activeKey: 'activity',
    showCopyVisible: false,
    scrollTop: '',
    info: {
      company: '兑吧科技',
      miniappName: '兑吧科技',
      logo: '//yun.duiba.com.cn/duiba_miniProgram/logo.png'
    },
    menu: [{
      key: 'activity',
      title: '活动管理',
      path: '/activity/list'
    }]
  },
  onUpdateShowCopy() {
    this.setData({
      showCopyVisible: false
    });
  },
  onLoad(query) {
    my.authorize({
      scopes: 'scope.userInfo',
      success: (res) => {
        
        sellerSave({}).then(res => {
          if (!res.success) {
            my.showToast({
              type: 'fail',
              content: res.message
            });
          }
        });
      },
      error: () => {
      }
    });
    // 页面加载
    routerInit.call(this, routerConfig);
  },
  onPageScroll: function (e) { // 获取滚动条当前位置
    this.setData({
      scrollTop: e.scrollTop,
    });
  },
  onMenuChange({ key, path }) {
    this.setData({
      activeKey: key
    });
    this.$router.push(path);
  },
  onChange({
    detail: {
      value
    }
  }) {
    console.log('************$router', value);
    if (value === '/activity') {
      value = '/activity/list';
    }
    if (value === "/help") {
      this.setData({
        showCopyVisible: true
      });
      return false;
    }
    this.$router.push(value);
    this.setData({
      activeKey: value
    });
  },
  onActiveKeyChange(event) {
    const {
      path
    } = event.target.dataset;
    this.setData({
      activeKey: path
    });
  }
});