import { rankTableValidator, validateRangeNumber, cardTableValidator,rankTimeValidator, isNumber, validatePositiveInteger, validateInteger, urlChecks, rateTableValidator } from "../../../utils/validate";

// 使用 async-validator 校验
// 文档地址: https://github.com/yiminghe/async-validator

export const descriptor = {

  title: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 12;
    },
    message: "请输入正确的活动名称"
  },

  timeRange: {
    required: true,
    validator: (rule, value) => {
      return !!value.every(v => !!v);
    },
    message: "请输入正确的活动时间"
  },

  rule: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: '请输入活动规则'
  },

  RateTable: {
    required: true, validator: cardTableValidator
  },
  RatePrizePool2: { required: true, validator: rateTableValidator },
  RatePrizePool3: { required: true, validator: rateTableValidator },
  RatePrizePool4: { required: true, validator: rateTableValidator },
  RatePrizePool5: { required: true, validator: rateTableValidator },
  RatePrizePool6: { required: true, validator: rateTableValidator },
  RatePrizePool7: { required: true, validator: rateTableValidator },
  RatePrizePool8: { required: true, validator: rateTableValidator },
  RatePrizePool9: { required: true, validator: rateTableValidator },
  tasks: {
    type: 'object',
    required: false,
    fields: {

      groupChat: {
        validator: (rule, val) => {
          return !!(val.link);
        },
        message: '请设置加入群聊任务'
      },

      orderDepositGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请设置下单定金商品任务'
      },
      collectGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请设置收藏商品任务'
      },

      orderGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请设置下单商品任务'
      },

      browseGoods: {
        validator: (rule, val) => {
          return !!(val.link);
        },
        message: '请设置浏览商品任务'
      },

      // member: {
      //   validator: (rule, val, cb, source) => {
      //     return !!val.value;
      //   },
      //   message: '请设置成为会员任务'
      // },

      // follow: {
      //   validator: (rule, val, cb, source) => {
      //     return !!val.value;
      //   },
      //   message: '请设置关注店铺任务'
      // },
      invites: {
        validator: (rule, val, cb, source) => {
          return !!val.shareTitle;
        },
        message: '请设置邀请任务'
      },
    }
  },
  shareTitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: "请输入分享标题"
  },
  shareSubtitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: "请输入分享副标题"
  },
  shareImage: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: "请上传分享图片"
  },

};

export const formatValidator = (descriptor, validators) => {
  validators = validators || {};
  Object.keys(descriptor).forEach(key => {
    if (descriptor[key].fields) {
      Object.keys(descriptor[key].fields).forEach(fieldKey => {
        validators[`${key}.${fieldKey}`] = {
          status: 'success',
          message: ''
        };
      });
    } else {
      validators[key] = {
        status: 'success',
        message: ''
      };
    }

  });
  return validators;
};