const { cloud } = getApp();
const { function: fc } = cloud;
import { chooseImage, getImageInfo, validateRangeNumber, isDot } from "/utils";
export const methods = {
  methods: {
    // 根据dataName  改变值
    onInputChangeByDataName(e) {
      const { name } = e.target.dataset;
      const { value } = e.detail;
      this.setDataByKey(value, name);
    },
    onTimeChange(timeRange, error, timeKeys) {
      const {
        formState
      } = this.data;

      this.setData({
        timeRange,
        [timeKeys[0] || 'startTime']: timeRange[0],
        [timeKeys[1] || 'endTime']: timeRange[1],
        formState: {
          ...formState,
          timeRange: {
            status: error ? 'error' : 'success',
            message: error || ''
          }
        }
      });
    },
    onChangeByDataName(val, key) {
      this.setDataByKey(val, key);
    },
    /**
     *根据key值改变数据, 支持key  a/a.b/a.b.c的形式
    *
    * @param {*} val
    * @param {string} key  
    */
    setDataByKey(val, key) {
      const keys = key.split('.');
      if (keys.length === 1) {
        this.setData({
          [keys[0]]: val
        });
      }
      if (keys.length === 2) {
        let targetKey = this.data[keys[0]];
        targetKey[keys[1]] = val;
        let newVal = Object.assign({}, targetKey);
        this.setData({
          [keys[0]]: newVal
        });
      }
      if (keys.length === 3) {
        let targetKey = this.data[keys[0]];
        targetKey[keys[1]][keys[2]] = val;
        let newVal = Object.assign({}, targetKey);
        this.setData({
          [keys[0]]: newVal
        });
      }
    },

    async uploadImage() {
      try {

        const res = await chooseImage();

        if (!res.apFilePaths.length) return;

        const { height, width, type, path } = await getImageInfo({
          src: res.apFilePaths[0],
        });
        const imageLimit = [500, 500];

        let imgBool = ~path.indexOf(".png") || ~path.indexOf(".jpg");
        if (height !== imageLimit[1] || width !== imageLimit[0] || !imgBool) {
          my.showToast({
            type: 'fail',
            content: '请按要求上传图片'
          });
          this.setData({
            shareImage: '',
          });
          return;
        }

        const { url } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: "image",
          fileName: path.split("/").pop(),
        });

        this.setData({
          shareImage: url,
        });
      } catch (error) {
        console.error(error);
      }
    },
  }

};