import moment from 'moment';
import schema from 'async-validator';
import { methods } from './mixins';
import { TASK_RATE_TYPE, CARD_LIST, collectCardConfig } from '../const';
import {
  descriptor,
  formatValidator
} from './validate';
import {
  getActivityDetail,
  saveActivityInfo,
} from '/api';
import {
  addFloat, setPrizeProbalityRange
} from '/utils/helper';

const THANKS_TYPE = 5;

var validator = new schema(descriptor);

Component({
  mixins: [methods],
  data: {
    CARD_LIST,
    labelCol: { fixedSpan: 5 },
    id: '',
    startTime: '',
    endTime: '',
    shareTitle: '',
    shareSubtitle: '',
    shareImage: '',
    title: '',
    timeRange: [],
    rule: '',

    RateTable: [],
    RatePrizePool2: [],
    RatePrizePool3: [],
    RatePrizePool4: [],
    RatePrizePool5: [],
    RatePrizePool6: [],
    RatePrizePool7: [],
    RatePrizePool8: [],
    RatePrizePool9: [],
    collectGoods: '',
    orderGoods: '',

    browseGoods: '',
    member: '',
    follow: '',
    tasks: {
      groupChat: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.FOREVER,
        times: "",
        title: "加入群聊",
        link: ""
      },
      collectGoods: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.FOREVER,
        times: "",
        title: "收藏商品",
        link: ""
      },
      orderGoods: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.FOREVER,
        times: "",
        title: "下单商品",
        link: ""
      },
      orderDepositGoods: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.FOREVER,
        times: "",
        title: "下单定金商品",
        link: ""
      },
      browseGoods: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.EVERYDAY,
        times: 3,
        title: "浏览页面",
        link: ""
      },
      member: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.FOREVER,
        times: "",
        title: "加入会员",
        link: ""
      },
      follow: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.FOREVER,
        times: "",
        title: "关注店铺",
        link: ""
      },
      invites: {
        value: 1,
        taskRateType: TASK_RATE_TYPE.NOLIMIT,
        times: "",
        title: "邀请好友",
        link: ""
      },
    },

    isEnd: false,
    isStart: false,
    originalStartTime: '',
    formState: formatValidator(descriptor),
    isPostParams: true
  },
  didMount() {
    const { id } = this.$page.$router.params;
    id && this.getActivityInfo(id);
  },
  methods: {
    // 获取activityId活动信息
    async getActivityInfo(activityId) {
      my.showLoading();
      try {
        const { success, data, message } = await getActivityDetail({ activityId });
        if (!success) {
          this.showFailToast(message);
          return;
        }

        this.setData({
          ...data,
          timeRange: [+data.startTime, +data.endTime],
          originalStartTime: +data.startTime,
          isStart: +data.startTime < Date.now(),
          isEnd: +data.endTime < Date.now(),
          tasks: data.tasks
        });
        my.hideLoading();
      } catch (error) {
        my.hideLoading();
        console.log(error, 'err');
      }
    },
    validateForm(data, target) {
      const _this = this;
      return new Promise((resolve, reject) => {
        validator.validate(data, (errors, fields) => {
          console.log('errors', errors);
          console.log('fields', fields);
          const {
            formState
          } = _this.data;
          _this.setFormTips(formState, errors, target);
          if (errors) {
            resolve(false);
          } else {
            resolve(true);
          }

          // validation passed
        });
      });
    },
    setFormTips(formState, errors, target) {
      errors = errors || [];
      let newValidator = {};
      Object.keys(formState).forEach(key => {
        let error = errors.filter(v => target ? v.field === target && v.field === key : v.field === key).length && errors.filter(v => v.field === key)[0];
        // 时间实时校验
        // if (key === 'timeRange' && formState[key].status === 'error') {
        //   return
        // }
        newValidator[key] = {
          status: error ? 'error' : 'success',
          message: error ? error.message : ''
        };
      });

      console.log('newValidator', newValidator);

      this.setData({
        formState: newValidator
      });
    },
    // 提交信息
    async onSubmit() {

      console.log(this.data, 'this.data');

      const isValidForm = await this.validateForm(this.data);
      if (!isValidForm) return;
      console.log('表演校验通过');

      const params = this.formatActivityParams(this.data);
      console.log('最后提交的数据', params);
      if (this.data.isPostParams) {
        this.setData({
          isPostParams: false
        });
        setTimeout(() => {
          this.setData({
            isPostParams: true
          });
        }, 2000);
        const { success, message } = await saveActivityInfo(params);
        if (success) {
          this.backList();
        } else {
          this.showFailToast(message);
        }
      }
    },
    showFailToast(text) {
      my.showToast({
        type: 'fail',
        content: text
      });
    },
    // 格式化参数
    formatActivityParams(params) {
      const {
        id = '',
        activityId = '',
        startTime,
        endTime,
        tasks,

        title,
        time,
        rule,
        shareTitle,
        shareSubtitle,
        shareImage,
        RateTable,
        RatePrizePool2,
        RatePrizePool3,
        RatePrizePool4,
        RatePrizePool5,
        RatePrizePool6,
        RatePrizePool7,
        RatePrizePool8,
        RatePrizePool9
      } = params;
      let prizeList = [];

      prizeList = [...prizeList, ...setPrizeProbalityRange(RateTable)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool2)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool3)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool4)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool5)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool6)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool7)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool8)];
      prizeList = [...prizeList, ...setPrizeProbalityRange(RatePrizePool9)];

      return {
        id,
        activityId,
        startTime: new Date(startTime).getTime(),
        endTime: new Date(endTime).getTime(),
        tasks,
        prizeList,
        collectCardConfig,
        // prizeInfoList: this.formatPrizeList(prizeInfoList),
        shareTitle,
        shareSubtitle,
        shareImage,
        title,

        rule,

      };
    },
    // 补足谢谢参与类型
    formatPrizeList(prizeInfoList = []) {
      let totalPercent = prizeInfoList.reduce((total, next) => {
        return total = addFloat(total, +next.probability);
      }, 0);
      // 排名类型不含谢谢参与
      if (prizeInfoList[0].rank) return prizeInfoList;
      let prizeInfoListCopy = prizeInfoList.concat().map((v, index) => ({
        ...v,
        level: index
      }));

      if (totalPercent < 100) {
        let thanksType = {
          type: THANKS_TYPE,
          name: '谢谢参与',
          probability: 100 - totalPercent
        };
        prizeInfoListCopy.push(thanksType);
      }
      return prizeInfoListCopy;
    },
    backList() {
      this.$page.$router.push("/activity/list");
    }
  },
});
