Component({
  mixins: [],
  data: {
    dialogVisible: false,
    isEdit: false,
    prizeDialogData: {}
  },
  props: {
    limit: 20,
    list: [],
    onChange: () => { },
    dataName: '',
    conditionKeys: [],
    imageLimit: [250, 250],
    prizeDataType: null,
    typeChecked: [],
    type:''
  },
  didMount() { },
  didUpdate() { },
  didUnmount() { },
  methods: {
    // 删除奖品
    handleDeleteClick(e) {
      const { index } = e.target.dataset.x;
      const { onChange, list, dataName } = this.props;
      onChange && onChange(list.filter(((i, k) => k !== index)), dataName);
    },
    addPrize() {
      const { limit, list } = this.props;

      if (list.length >= limit) {
        my.showToast({ type: 'fail', content: `最多创建${limit}个奖励配置` });
        return;
      }
      this.setData({
        dialogVisible: true,
        isEdit: false,
        prizeDialogData: {}
      });

    },
    onEditPrize(e) {
      const { name, x } = e.target.dataset;
      this.setData({
        prizeDialogData: x,
        isEdit: true,
        dialogVisible: true
      });
    },
    onCloseDialog() {
      this.setData({ dialogVisible: false });
    },
    onPrizeUpdate(data, index) {
      const { onChange, list, dataName } = this.props;
      // 切换不同奖品时改为逻辑删除
      if (list[index].type !== data.type) {
        console.log('更换奖品的id');
        data._id = null;
      }
      const updatedData = list.map((v, i) => {
        if (index === i) return { ...v, ...data };
        return v;
      });

      onChange && onChange(updatedData, dataName);
    },
    onPrizeAdd(data) {
      const { list, onChange, dataName } = this.props;

      onChange && onChange([...list, data], dataName);
    }
  },
});
