import { chooseImage, getImageInfo, validateRangeNumber } from "/utils";
const { cloud } = getApp();
const { function: fc } = cloud;

Component({
  mixins: [],
  data: {
    isError: false
  },
  props: {
    imageLimit: [250, 250],
    onSuccess: () => {},
    onError: () => {},
    url: '',
    dataName: ''
  },
  didMount() {},
  didUpdate() {},
  didUnmount() {},
  methods: {
    async uploadImage() {
      const { onSuccess, onError, dataName, imageLimit } = this.props;
      try {
        const res = await chooseImage();

        if (!res.apFilePaths.length) return;

        const { height, width, type, path } = await getImageInfo({
          src: res.apFilePaths[0],
        });

        let imgBool = ~path.indexOf(".png") || ~path.indexOf(".jpg");
        if (height !== imageLimit[1] || width !== imageLimit[0] || !imgBool) {
          onError && onError({height, width, type, path });
          this.setData({
            isError: true
          });
          return;
        }
        this.setData({
          isError: false
        });

        const { url } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: "image",
          fileName: path.split("/").pop(),
        });

        onSuccess && onSuccess(url, dataName);
      } catch (error) {
        onError({}, error);
      }
    },
  },
});
