const { cloud } = getApp();
const { function: fc } = cloud;
import { passUrlList, urlCheck } from "../../../utils/helper";

import { chooseImage, getImageInfo, validateRangeNumber, isDot } from "/utils";

Component({
  mixins: [],
  data: {
    showDialogMask: true,
    dataSource: [
      { label: 1, value: 1 },
      { label: 2, value: 2 },
      { label: 3, value: 3 },
      { label: 4, value: 4 },
      { label: 5, value: 5 },
      { label: 6, value: 6 },
      { label: 7, value: 7 },
      { label: 8, value: 8 },
      { label: 9, value: 9 },
      { label: 10, value: 10 },
    ],
    taskRateType: 1,
    times: '',
    title: '',
    link: '',
    itemIds: '',
    value: '',
    shareImage: '',
    shareTitle: '',
    shareSubtitle: '',
  },
  props: {
    visible: false,
    hasLink: false,
    hasItems: false,
    hasImages: false,
    shareImage: '',
    shareTitle: '',
    shareSubtitle: '',
    type: '',
    unit: '',
    frequency: '',
    imageLimit: [],
    taskData: {
      title: '',
      taskRateType: 1,
      times: '',
      value: '',
      itemIds: ''
    },
    onClose: () => { },
    onUpdate: () => { }
  },
  didMount() {
    this.initData();
  },
  didUpdate() { },
  didUnmount() { },
  methods: {
    async uploadImage() {
      try {
        this.setData({
          showDialogMask: false,
        });
        const res = await chooseImage();
        this.setData({
          showDialogMask: true,
        });

        if (!res.apFilePaths.length) return;

        const { height, width, type, path } = await getImageInfo({
          src: res.apFilePaths[0],
        });
        const { imageLimit } = this.props;

        let imgBool = ~path.indexOf(".png") || ~path.indexOf(".jpg");
        if (height !== imageLimit[1] || width !== imageLimit[0] || !imgBool) {
          my.showToast({
            type: 'fail',
            content: '请按要求上传图片'
          });
          this.setData({
            shareImage: '',
          });
          return;
        }

        const { url } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: "image",
          fileName: path.split("/").pop(),
        });

        this.setData({
          shareImage: url,
          showDialogMask: true,
        });
      } catch (error) {
        this.setData({
          showDialogMask: true,
        });
        console.error(error);
      }
    },
    initData() {
      Object.keys(this.props.taskData).forEach(key => {
        this.setData({
          [key]: this.props.taskData[key]
        });
      });
    },
    onCloseDialog() {
      this.props.onClose();
    },
    onTimesChange(e) {
      const { value } = e.detail;
      this.setData({
        times: value
      });
    },
    onItemIdsChange(ids) {
      this.setData({
        itemIds: ids
      });
    },
    onTaskRateTypeChange(e) {
      const { value } = e.detail;
      this.setData({
        taskRateType: value
      });
    },
    onChange(e) {
      const { value } = e.detail;
      const { name } = e.target.dataset;
      this.setData({
        [name]: value
      });
    },
    onSaveTask() {
      const { title, link, value, taskRateType, times, itemIds, shareImage, shareTitle, shareSubtitle } = this.data;
      if (!title.trim()) {
        my.showToast({
          type: 'fail',
          content: '请输入任务标题'
        });
        return;
      }

      if (this.props.hasLink && !urlCheck(link, passUrlList).status) {
        my.showToast({
          type: 'fail',
          content: urlCheck(link, passUrlList).message
        });
        return;
      }

      if (this.props.hasItems && !itemIds) {
        my.showToast({
          type: 'fail',
          content: '请选择商品'
        });
        return;
      }

      if (!value || !validateRangeNumber(value, [1, 999])) {
        my.showToast({
          type: 'fail',
          content: '请输入正确的任务奖励'
        });
        return;
      }
      let taskData = { ...this.props.taskData, title, link, value, taskRateType, times, itemIds, type: this.props.type };
      
      // 邀请任务
      if (this.props.hasImages) {
        if (!shareTitle) {
          my.showToast({
            type: 'fail',
            content: '请输入分享标题'
          });
          return;
        }
        if (!shareSubtitle) {
          my.showToast({
            type: 'fail',
            content: '请输入分享副标题'
          });
          return;
        }
        if (!shareImage) {
          my.showToast({
            type: 'fail',
            content: '请上传分享图片'
          });
          return;
        }
        taskData.shareImage = shareImage;
        taskData.shareTitle = shareTitle;
        taskData.shareSubtitle = shareSubtitle;
      }

      this.props.onUpdate && this.props.onUpdate(taskData);

      this.onCloseDialog();
    }
  },
});
