const { cloud } = getApp();
const { function: fc } = cloud;
import dayjs from 'dayjs';

Component({
  mixins: [],
  data: {
    dingNumber: '30549862',
    diffDay: '',
    time: ''
  },
  props: {
    info: () => {
      return  {
        company: '兑吧科技',
        miniappName: '兑吧科技',
        logo: '//yun.duiba.com.cn/duiba_miniProgram/logo.png'
      };
    },
    deadline: '',
    activeKey: '',
    onMenuChange: () => {}
  },
  didMount() {
    this.setValidTime();
  },
  didUpdate(props, newProps) {
    console.log(props, newProps);
  },
  didUnmount() {},
  methods: {
    handleMenuClick(event) {
      let { key, path } = event.target.dataset;
      this.props.onMenuChange({ key, path });
    },
    setValidTime() {
      const { deadline } = this.props;
      let time;
      let diffDay;
      if (deadline) {
        diffDay = dayjs(deadline).diff(+new Date(), 'd');
        time = dayjs(deadline).format('YYYY-MM-DD');  
        this.setData({ diffDay, time });
      }
      
    },
    help() {
      my.qn.navigateToWebPage({
        url: "https://www.yuque.com/pangkaifeng/gfpf5s",
        success: res => {

        },
        fail: res => {

        }
      });
    },
    renevwal() {
      my.qn.navigateToWebPage({
        url: "https://fuwu.taobao.com/ser/detail.htm?service_code=FW_GOODS-1001068300&tracelog=search&from_key=%E6%98%9F%E7%90%83%E5%A4%A7%E4%BD%9C%E6%88%98",
        success: res => {

        },
        fail: res => {

        }
      });
    },
    service() {
      // my.qn.navigateToWebPage({
      //   url: "http://amos.alicdn.com/getcid.aw?v=2&uid=%E6%9D%AD%E5%B7%9E%E5%85%91%E5%95%8A&site=cntaobao&s=1&groupid=0&charset=utf-8",
      //   success: res => {

      //   },
      //   fail: res => {

      //   }
      // })
      const { dingNumber } = this.data;

      my.alert({
        title: '钉钉商家群',
        content: dingNumber,
        buttonText: '复制',
        success: () => {
          my.setClipboard({
            text: dingNumber,
            success: () => {
              my.showToast({
                type: 'success',
                content: '复制成功'
              });
            }
          });
        },
      });
    },
  },
});
