// eslint-disable-next-line import/no-commonjs
const path = require('path')
const { hasCanvas, defaultPlugins, canvasComps } = require('./default').default

const config = {
  projectName: 'taro-test',
  date: '2021-2-25',
  designWidth: 750,
  deviceRatio: {
    640: 2.34 / 2,
    750: 1,
    828: 1.81 / 2
  },
  sourceRoot: 'src',
  outputRoot: 'dist',
  alias: {
    '@': path.resolve(__dirname, '..', 'src/')
  },
  plugins: hasCanvas ? [...defaultPlugins,[ // 是否开启原生页面自动注入
        path.resolve(__dirname,'..')+'/plugin/changeAppJsonPlugin.js'
      ]
    ] : defaultPlugins,
  defineConstants: {
  },
  copy: {
    patterns: hasCanvas ? canvasComps : [],
    options: {
    }
  },
  framework: 'react',
  mini: {
    compile: {
      exclude: []
    },
    postcss: {
      pxtransform: {
        enable: true,
        config: {

        }
      },
      url: {
        enable: true,
        config: {
          limit: 1024 // 设定转换尺寸上限
        }
      },
      cssModules: {
        enable: true, // 默认为 false，如需使用 css modules 功能，则设为 true
        config: {
          namingPattern: 'module', // 转换模式，取值为 global/module
          generateScopedName: '[name]__[local]___[hash:base64:5]'
        }
      }
    },
    webpackChain(chain, webpack) {
      chain.module
        .rule('less')
        .pre()
        .use('style-resources')
        .loader('style-resources-loader')
        .options({
          patterns: path.resolve(__dirname, '../src/styles/index.less'),
          injector: 'append'
        })
    }
  },
  h5: {
    publicPath: '/',
    staticDirectory: 'static',
    postcss: {
      autoprefixer: {
        enable: true,
        config: {
        }
      },
      cssModules: {
        enable: false, // 默认为 false，如需使用 css modules 功能，则设为 true
        config: {
          namingPattern: 'module', // 转换模式，取值为 global/module
          generateScopedName: '[name]__[local]___[hash:base64:5]'
        }
      }
    },
    webpackChain(chain, webpack) {
      chain.module
        .rule('less')
        .pre()
        .use('style-resources')
        .loader('style-resources-loader')
        .options({
          patterns: path.resolve(__dirname, '../src/styles/index.less'),
          injector: 'append'
        })
    }
  }
}

module.exports = function(merge) {
  if (process.env.NODE_ENV === 'development') {
    return merge({}, config, require('./dev'))
  }
  return merge({}, config, require('./prod'))
}
