# 进度条组件

---



## 何时使用

- 当某个页面需要展示累计邀请、分等级奖励进度条、累计签到等。

## 目录结构
  `ProgressContext` 进度条全局默认配置  
  
  `ProgressNode` 进度条节点

## API

| 参数 | 说明 | 类型 | 默认值 | 版本 |
| --- | --- | --- | --- | --- |
| levelList | 节点数据 | ArrayObject | 见下面示例一 |  |
| currentValue | 当前进度值 | Numbver | 0 |  |
| className | 进度条节点组样式 | Object | - |  |
| maxLevel | 最大值 | Number | 15 |  |
| width | 进度条长度 | Number | 500 |  |
| BtnTexts | 进度按钮状态文本 | Object | {UNREACH: '待解锁',REACH_UNRECEIVED: '已解锁',REACH_RECEIVED: '已领取'} |  |
| onReceviceClick | 点击进度按钮回调 | Function | （id）=>{} |  |
| nodeClassName | 节点样式 | Object | - |  |
| iconImgClassName | icon图片样式 | Object | - |  |
| iconTxtClassName | icon文本样式 | Object | - |  |
| descClassName | 描述样式 | Object | - |  |
| btnClassName | 进度按钮样式 | Object | - |  |
| activeBtnClassName | 进度按钮可点样式 | Object | - |  |
| disableBtnClassName | 进度按钮不可用样式 | Object | - |  |

## 示例一

```
[
  {
    id: 0,  //节点id
    levelValue: 0, //节点值
    isReceived: true, //是否已领取
    iconInfo: {
      iconUrl: '//yun.dui88.com/tebuXinYuan/main-circle-tip.png',
      iconTxt: ''
    },
    descInfo: {
      descTxt: '等级1'
    }
  },
  {
    id: 1,
    levelValue: 5,
    isReceived: false,
    iconInfo: {
      iconUrl: '//yun.dui88.com/tebuXinYuan/main-circle-tip.png',
      iconTxt: ''
    },
    descInfo: {
      descTxt: '等级2'
    }
  }
]
```
