##### swiperView 滑动

|    配置项    |   类型   |    描述     |    默认值    |  备注  |
| :--------   | :-----:  | :--------: |   :-----:   | :---:|
| swiperList    |   Array   |    滑动数组   |  [...]  | / |
| disableTouch |   Boolean   |  是否可手动滑动   | false |  true 可滑动  false 不可滑动  |
| autoplay   |   Boolean   |  是否自动切换   | false |/|
| circular   |   Boolean   |  是否采用衔接滑动| false |/|
| vertical   |   Boolean   |  是否垂直切换| false |/|
| duration   |   Number   |  滑动动画时长| 1000 |/|
| interval   |   Number   |  自动切换时间间隔| 1500 |/|
| easingFunction|String   |  缓动动画类型| linear |'default','linear'  'easeInCubic'     'easeOutCubic'  'easeInOutCubic'|
| swiperGroup   |   Object   | 整个swiper的宽高 |{width:300,height:400}|/|
| swiperContent   |   Object   | 单个swiperItem的宽高 |{width:300,height:400}|/|
| imgContent   |   Object   | 图片宽高 |{width:200,height:200}|/|
| textContent   |   Object   | 文本宽高 |{width:300,height:60}|/|

#### swiperList数据
```json
    [
        {
            "image":"",//图片链接,图片宽高需要在less中修改
            "content":"",//图片描述
            // 或者手动修改组件中的字段名称 ...
        },
      	// ...
    ]
```

+ 使用
```jsx
import SwiperView from '@/components/_tb_comps/SwiperView/SwiperView'

const swiperConfig = { //不传走默认配置
    swiperList:[], 
    isSpecial:true,
    easingFunction:`linear`,
    circular:true,
    autoplay:false,
    vertical:false,
    duration:1000,
    interval:1500,
    disableTouch:false,
    swiperGroup:{width:300,height:400},
    swiperContent:{width:300,height:400},
    imgContent:{width:200,height:200},
    textContent:{width:300,height:60}
  }

export const Index = () => {
  return(
    <SwiperView {...swiperConfig} swiperList={swiperList} />
  )
}
```