import React, { useState, useEffect,useRef } from "react";
import { View, Image, Text, Swiper, SwiperItem } from "@tarojs/components";

import './SwiperView.less'
import Taro,{showToast,redirectTo,navigateTo} from '@tarojs/taro'
export const EASING_WAYS = {
    'DEFAULT':'default',
    'LINEAR':'linear',
    'EASEIN':'easeInCubic',
    'EASEOUT':'easeOutCubic',
    'EASEINOUT':'easeInOutCubic'
}
const SwiperView = (props) => {
    /**
     * @description swiperList
     * {image,content,hasBtn}
     */
  const {
    swiperList=[], 
    isSpecial=true,
    easingFunction=`${EASING_WAYS.LINEAR}`,
    circular=true,
    autoplay=false,
    vertical=false,
    duration=1000,
    interval=1500,
    disableTouch=false,
    swiperGroup={width:300,height:400},
    swiperContent={width:300,height:400},
    imgContent={width:200,height:200},
    textContent={width:300,height:60},
    showLeftRightBtn=true
  } = props;

  const [currentIndex, setCurrentIndex] = useState(0);
  /**
   * @description onchange事件
   * @param {*} e 
   */
  const swiperChange = e => {
    console.log("e", e);
    setCurrentIndex(e.detail.current);
  };
  
  /**
   * @description 入场/出场动画
   * @param {*} index 数组索引值
   * @returns 返回类名
   */
  const useCustomAni = (index) => {
    return `${currentIndex > 0 && currentIndex == index && 'move_in'} ${currentIndex - 1 == index && 'move_out'}`
  }

  /**
   * @description 获取当前卡片详情之类
   */
  const getCurrentDetail = (item) => {
    showToast({
      title:'111'
    })
  }

  return (
    <View className="scroll_container">
      {/* <View className='left_btn' >&lt;&lt;</View> */}
      <Swiper
        className="swiper_group"
        current={currentIndex}
        easingFunction={easingFunction}
        onChange={swiperChange}
        circular={circular}
        vertical={vertical}
        autoplay={autoplay}
        duration={duration}
        interval={interval}
        disableTouch={disableTouch}
        style={{
          width:`${swiperGroup.width/100}rem`,
          height:`${swiperGroup.height/100}rem`
        }}
      >
        {swiperList.length &&
          swiperList.map((item, i) => (
            <SwiperItem>
              <View
                className={`scroll_item ${i === currentIndex && isSpecial ? "current_item" : ""} ${useCustomAni(i)}`}
                style={{
                  width:`${swiperContent.width/100}rem`,
                  height:`${swiperContent.height/100}rem`
                }}
                onTap={()=>getCurrentDetail(item)}
              >
                {/* {i === currentIndex &&  (
                  <Image
                    className="checkPic"
                    src="https://yun.dui88.com/tebuXinYuan/checkGoods.png"
                  ></Image>
                )} */}
                <View className="item_img_content">
                  {/* 单个swiper主要内容 */}
                  <Image 
                    className="img" 
                    style={{
                      width:`${imgContent.width/100}rem`,
                      height:`${imgContent.height/100}rem`
                    }} 
                    src={item.image}></Image>
                  {
                    item?.content &&
                    <View 
                      className='text_content'
                      style={{
                        width:`${textContent.width/100}rem`,
                        height:`${textContent.height/100}rem`,
                        padding:`${0/100}rem ${16/100}rem`
                      }}
                    >
                      <View className='text' >{item.content}</View>
                    </View>
                  }
                </View>
              </View>
            </SwiperItem>
          ))}
      </Swiper>
      
      {/* <View className='right_btn' >&gt;&gt;</View> */}
    </View>
  );
};
export default SwiperView;
