import React, { useState, useEffect, useRef } from 'react'
import { View } from '@tarojs/components'
import GoodsTitle from '@/components/_tb_comps/GoodsTitle/GoodsTitle'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRouter } from '@tarojs/taro'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
import styles from './cartGoods.module.less'

const { commonToast, showSkuModal } = tbccTs.tb

const cartConfig = {
  taskType: 'cartGoods',
  type: '01',
  bg: '//yun.dui88.com/taobaomini/clientCTest/goods_bg@2x.png',
  head: {
    image: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    width: 750,// 头部banner/title 宽度
    height: 120,// 头部banner/title 高度
  },
  image: {
    banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
    title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
    no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
    img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png'
  },
  color: '#181818'
}

function CartGoodsPage() {
  const router = useRouter()
  const [goodsList, setGoodsList] = useState([])
  const { itemIds } = router?.params
  // 收藏状态
  const collectflag = useRef(false)

  useEffect(() => {
    getGoodsList()
  }, [])

  const getGoodsList = async () => {
    const { data } = await API.getCollectGoodsList({ itemIds })
    setGoodsList(data?.list || [])
  }
  // 加入购物车 // 对应itemId为 574141925233 skuId为4018047819826 数量为4
  const onCompleteTask = useThrottle(async (itemId, collected) => {
    console.log(itemId)
    if (collected) {
      commonToast('您已加购过该商品了')
      return;
    }
    if(!collectflag.current){
      const { status, quantity } = await showSkuModal(String(itemId))
      if (status == "addCartSuccess") {
        const { success } = await API.doCompleteTask({ taskType: cartConfig.taskType, itemId, count: quantity })
        if (success) {
          collectflag.current = true
          getGoodsList()
          commonToast('加购成功')
        }
      }
    } else {
      commonToast('该任务今天已完成，明天再来吧~')
    }
  }, 2000);

  return (
    <View className={styles['page-container']}>
      <View className={styles['page-psd-container']} style={{ background: `url(${cartConfig.bg}) no-repeat`, backgroundSize: '750rpx 1624rpx' }}>
        <View className={styles['page-content']}>
          <View className={styles['page-content__title']}>
            <GoodsTitle config={cartConfig.head}/>
          </View>
          <View className={styles['page-content__list']}>
            <GoodsList goodsList={goodsList} task={cartConfig} onOpenDetail={(itemId,collected) => onCompleteTask(itemId,collected)} />
          </View>
        </View>
      </View>
    </View>
  )
}

export default CartGoodsPage
