import React, { useEffect, useRef, useState } from 'react'
import { View } from '@tarojs/components'
import GoodsTitle from '@/components/_tb_comps/GoodsTitle/GoodsTitle'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useDidShow, useRouter, useDidHide } from '@tarojs/taro'
import API from '@/api'
import { TASK_CONFIG, BROSE_GOOD_TYPE } from '@/const'
import { commonToast } from 'tbcc-sdk-ts/lib/core/tb'
import styles from './browseGoods.module.less'

export const LOAD_OBJ = {
  PICTURE:'PICTURE',
  NUMBER:"NUMBER",
  DEFAULT:""
}
const browseConfig = {
  taskType: 'browseGoods',
  type: '01',
  bg: '//yun.dui88.com/taobaomini/clientCTest/goods_bg@2x.png',
  head: {
    image: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    width: 750,// 头部banner/title 宽度
    height: 120,// 头部banner/title 高度
  },
  image: {
    banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
    title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
    no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
    img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png'
  },
  color: '#181818',
  loadFlag: LOAD_OBJ.PICTURE
}

const list = [
  {
      "itemId":41762748280,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01oVcb3x1EAwGvKOhgC_!!2032870312-0-picasso.jpg",
      "price":"89.90",
      "name":"避孕套超薄中号冈本官方正品旗舰店安全套套子避育男用持润久0.01",
      "url":"https://item.taobao.com/item.htm?id=41762748280&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01DypJaF1EAwCLTysGt_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01GMKADp1EAwCHgCziU_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01mhBuAj1EAwCPBvsEt_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01m96nH81EAwCJP9jFC_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01u9zYTu1EAwCrf2mpO_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01cKa55c1EAwCHEA0aZ_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01Fs58Mj1EAwCKIhSkW_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN011AVYEO1EAwCO1aTxl_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;br&gt; &lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01JNEZb41EAwF9ZpHvM_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01I9m2SM1EAwCUjIVLB_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":637727538858,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01Sr35MC1EAwGIQZZub_!!0-item_pic.jpg",
      "price":"94.90",
      "name":"冈本旗舰店0.03白金超薄避孕套系列6片装003套套男用安全成人用品",
      "url":"https://item.taobao.com/item.htm?id=637727538858&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01CD1sXk1EAwAVDtqrK_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01ZXWOHW1EAwC2Mgi4B_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01pDWAa81EAwANGIMgD_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;br&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":630862853821,
      "image":"https://img.alicdn.com/bao/uploaded/i4/2032870312/O1CN017ywnYM1EAwGgKVjwJ_!!0-item_pic.jpg",
      "price":"179.90",
      "name":"冈本官方旗舰店超薄避孕套超值量贩装男用持久情趣套套正品安全套",
      "url":"https://item.taobao.com/item.htm?id=630862853821&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01h16kYf1EAwELr3jxo_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01I9m2SM1EAwCUjIVLB_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":604642839549,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01kgEmZd1EAwGG7LTjo_!!2-item_pic.png",
      "price":"219.00",
      "name":"【0.03新品贴合润滑】冈本官方旗舰店正品003贴身滑超薄避孕套6片",
      "url":"https://item.taobao.com/item.htm?id=604642839549&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01RyCFOb1EAwAWgpY9u_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01gqhdui1EAwAZewDwe_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01TTrnlO1EAwAVkygwZ_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01usea1E1EAwC06qxzR_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01vi2LyK1EAwATKCPTw_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01voDvgs1EAwAVkz1ip_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":647187674381,
      "image":"https://img.alicdn.com/bao/uploaded/i3/2032870312/O1CN01Er4eOL1EAwH6MkLJF_!!0-item_pic.jpg",
      "price":"179.90",
      "name":"冈本官方旗舰店避孕套超薄零感套套男用情趣持久套正品安全套byt",
      "url":"https://item.taobao.com/item.htm?id=647187674381&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01kDrwVC1EAwG5w1vPD_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01Xjmj2l1EAwFyEYG9t_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01fiQrlp1EAwFzKpbZ1_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01kSg2Lm1EAwFsgUDV7_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01OfvbZl1EAwG1m9Wwa_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01sGj94k1EAwG564H4r_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01ugsEU91EAwFyEYnST_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01ovTYBJ1EAwFwic4TB_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01z5KJkE1EAwFyEYzvj_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":603002986449,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01JeXve11EAwGfjzHqZ_!!0-item_pic.jpg",
      "price":"98.80",
      "name":"冈本003避孕套超薄安全套官方旗舰店正品男用超润滑套套byt",
      "url":"https://item.taobao.com/item.htm?id=603002986449&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01gldzV81EAwANJwbfI_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01CJP32M1EAwBxRaECR_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01xZIKbT1EAwANJvbL2_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;br&gt; &lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01wl11iM1EAwExCe0Er_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;br&gt; &lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01eyMPas1EAwF8K9jFd_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt;"
  },
  {
      "itemId":637285661487,
      "image":"https://img.alicdn.com/bao/uploaded/i4/2032870312/O1CN01IZuIx51EAwH71unXs_!!0-item_pic.jpg",
      "price":"199.00",
      "name":"【入会享5折】冈本旗舰店避孕套超薄润滑男避育套套003安全套6片",
      "url":"https://item.taobao.com/item.htm?id=637285661487&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01GMKADp1EAwCHgCziU_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01mhBuAj1EAwCPBvsEt_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01cKa55c1EAwCHEA0aZ_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01I9m2SM1EAwCUjIVLB_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":643979759067,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01fFwlFa1EAwGl7ya2k_!!0-item_pic.jpg",
      "price":"199.00",
      "name":"冈本官方正品旗舰店避孕套超薄颗粒情趣超润滑男用持久安全套",
      "url":"https://item.taobao.com/item.htm?id=643979759067&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01pd28f41EAwFVVhXAi_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01kafRe91EAwFS4kGcR_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01y7BBmU1EAwFS4iK2b_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN017OO1Z01EAwFTDmp3a_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01n1vpre1EAwFU0mSLb_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01c2QGud1EAwFHyDLYN_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":625197198308,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01kNRnan1EAwGdiesng_!!0-item_pic.jpg",
      "price":"668.00",
      "name":"【003囤货装】冈本官方旗舰店正品0.03超薄避孕套003套套男用安全",
      "url":"https://item.taobao.com/item.htm?id=625197198308&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01TGRvJM1EAwBJUhzHz_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN016psrAS1EAwBStb2i1_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01vgi4u31EAwBLXAcpw_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01Jsr9wx1EAwBM8KyFC_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01udczt51EAwBGbVMK2_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01M2FO1g1EAwBJ1gVsf_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01P6B05q1EAwBIbadco_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01yQT8MW1EAwBJ1hiGj_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":44953265864,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN012wDChu1EAwGqxJOyv_!!0-item_pic.jpg",
      "price":"149.00",
      "name":"避孕套冈本003超薄正品旗舰店安全套套中号男女延0.01时持情趣久",
      "url":"https://item.taobao.com/item.htm?id=44953265864&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01z0BYYj1EAwDCcpEnX_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;br&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt; &lt;/p&gt;"
  },
  {
      "itemId":528265530793,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01O0O4Lp1EAwGg4y0za_!!0-item_pic.jpg",
      "price":"89.90",
      "name":"【玻尿酸润滑液】冈本润滑油剂夫妻用品水溶性人体男女用情趣私处",
      "url":"https://item.taobao.com/item.htm?id=528265530793&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN0194cqIZ1EAw8a9Q5Ur_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01bn3VA01EAw8Ws4h1K_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN010gyaUx1EAw8W7BV59_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN017RwKuy1EAw8W7AYqU_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01hU5Dio1EAw7WavDYK_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01zSilG81EAw7UZdHEo_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN015Dwgbo1EAwABWdxhH_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01QS6bvG1EAwAGE8EcD_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01lBw0VC1EAw7UwVDsM_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt;"
  },
  {
      "itemId":573293943564,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01oVgaq31EAwGOZekQN_!!2-item_pic.png",
      "price":"79.90",
      "name":"冈本官方旗舰店避孕套无感透薄套套10片装男用持久超润滑安全套",
      "url":"https://item.taobao.com/item.htm?id=573293943564&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img class=\"desc_anchor\" id=\"desc-module-1\" src=\"https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif\"&gt;&lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01Gbu0K61EAw9HWEQ12_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01NZpRwk1EAw9RG1C6q_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01wJn0UL1EAw9QTRXOz_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN014ZFTtX1EAw9N9EZdY_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01pEEPIK1EAw9P8bbos_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01tMUjq71EAw9PeR25p_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":38049467649,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01etTsvP1EAwGfksH6W_!!0-item_pic.jpg",
      "price":"139.00",
      "name":"【冰感透薄】冈本安全套旗舰店超薄避孕套男用套套情趣男正品byt",
      "url":"https://item.taobao.com/item.htm?id=38049467649&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01yG6tDq1EAwAWWu650_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01btyEB91EAwAecwKf7_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01hRXbQQ1EAwAZRqKdV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01bfUT9F1EAwAeWAPGV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":45536880524,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01ugAFmM1EAwGjzOh0C_!!0-item_pic.jpg",
      "price":"288.00",
      "name":"【超薄新体验】冈本官方旗舰店超薄避孕套男用套套正品男用安全套",
      "url":"https://item.taobao.com/item.htm?id=45536880524&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01yG6tDq1EAwAWWu650_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01btyEB91EAwAecwKf7_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01hRXbQQ1EAwAZRqKdV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01bfUT9F1EAwAeWAPGV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN012SG1LD1EAwDv7abeX_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":564942778404,
      "image":"https://img.alicdn.com/bao/uploaded/i4/2032870312/O1CN01UzTahU1EAwH4frEh0_!!0-item_pic.jpg",
      "price":"109.90",
      "name":"冈本官方旗舰店0.02避孕套003超薄0.01套套男用持久情趣安全套",
      "url":"https://item.taobao.com/item.htm?id=564942778404&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01ZDSPn51EAwAXqrEgQ_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01btyEB91EAwAecwKf7_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01hRXbQQ1EAwAZRqKdV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01bfUT9F1EAwAeWAPGV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":631248349054,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01KPS5bN1EAwGjkwF6x_!!0-item_pic.jpg",
      "price":"139.00",
      "name":"冈本官方旗舰店超薄避孕套超值装安全套男用超润滑持久套套byt",
      "url":"https://item.taobao.com/item.htm?id=631248349054&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p style=\"text-align: center;\"&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01GMKADp1EAwCHgCziU_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01mhBuAj1EAwCPBvsEt_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01Fs58Mj1EAwCKIhSkW_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN011AVYEO1EAwCO1aTxl_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p style=\"text-align: center;\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01I9m2SM1EAwCUjIVLB_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;a href=\"https://market.m.taobao.com/app/miniapp-biz/qrcode/index.html?_ariver_appid=3000000002153653&amp;page=pages%2Flanding%2Flanding%3FpageId%3D1464604\" target=\"_blank\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01UgfLNC1EAwCD3uttE_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/a&gt;&lt;/p&gt;"
  },
  {
      "itemId":630732514531,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01lmfW7b1EAwGEUyCe2_!!2-item_pic.png",
      "price":"49.00",
      "name":"冈本SKIN超薄紧型避孕套男用10片旗舰店正品安全套成人用品byt",
      "url":"https://item.taobao.com/item.htm?id=630732514531&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01pfYSAQ1EAw7oOafO2_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01WqGLoC1EAwFgiMbJI_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01J5VNzk1EAw7mKzGVh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01z0oouU1EAw7ecoIER_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN019LZzLp1EAw7ouD7uS_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01jSTEph1EAw7mKyOUN_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt;"
  },
  {
      "itemId":572833841756,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01JELKbs1EAwGgA9WfX_!!0-item_pic.jpg",
      "price":"149.00",
      "name":"冈本旗舰店0.03白金系列超薄避孕套情趣男用润滑裸入10片装安全套",
      "url":"https://item.taobao.com/item.htm?id=572833841756&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01gSu0FR1EAwASu6bP2_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nLPaor1EAwAZcWeSY_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01vjg8yZ1EAwAXUZygX_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01tzkDTC1EAwBxwcEUO_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01jusdJ81EAwAYsLdUH_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01uT2aib1EAwARxJfmP_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01nSh0Iw1EAwAXDlulb_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt;&lt;img class=\"desc_anchor\" id=\"desc-module-4\" src=\"https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt;"
  },
  {
      "itemId":573611107609,
      "image":"https://img.alicdn.com/bao/uploaded/i1/2032870312/O1CN01JFWU2L1EAwGF4ruj4_!!2-item_pic.png",
      "price":"74.90",
      "name":"冈本官方旗舰店避孕套超润滑透薄系列套套10片装男用持久正品byt",
      "url":"https://item.taobao.com/item.htm?id=573611107609&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01emfrEX1EAw9RGRuVM_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01OOy6tH1EAw9QTs3J2_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01XikXmp1EAw9PenOCT_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01HNSsuT1EAw9N9bjO5_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01djdOlE1EAw9RGR2UT_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN019TJ0Kz1EAw9NS3qAH_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01FDIokI1EAwC34q9Rv_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qEQRnn1EAwC4wD3yV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i1/2032870312/O1CN01nZQXOR1EAwGfmbYYh_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  },
  {
      "itemId":628533160056,
      "image":"https://img.alicdn.com/bao/uploaded/i3/2032870312/O1CN01k8mmS61EAwH4fgMLp_!!0-item_pic.jpg",
      "price":"119.90",
      "name":"【肤感3合1】冈本官方旗舰店正品001超薄避孕安全套套男用003零感",
      "url":"https://item.taobao.com/item.htm?id=628533160056&amp;spm=2015.32819095.0.0",
      "desc":"&lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01VDrkib1EAwCNFpGpU_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN010gKrZl1EAwBxD25D2_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i3/2032870312/O1CN01vkIjpb1EAwBIqGsJL_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt; &lt;p&gt; &lt;/p&gt; &lt;p&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i2/2032870312/O1CN01wykYTn1EAwCSuA1fV_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;img src=\"https://img.alicdn.com/imgextra/i4/2032870312/O1CN01qG819P1EAwGllcAoE_!!2032870312.jpg\" align=\"absmiddle\"&gt;&lt;/p&gt;"
  }
]

function BrowseGoodsPage() {
  const { params: { itemIds, keepTime } } = useRouter()
  const { browseGoodType, browseTime = 15 } = TASK_CONFIG
  
  const [ startTimer, setStartTimer ] = useState(false)
  const preBrowseTime = useRef(null)
  const currentItemId = useRef('')
  const usePercent = useRef(0)
  const [accumulateTime, setAccumulateTime] = useState(+keepTime || 15)

  const browserTimer = useRef(null)
  const [goodsList, setGoodsList] = useState([])
  // test
  // const [goodsList, setGoodsList] = useState(list)

  
 

  useEffect(() => {
    getGoodsList()
  }, [])
  // 浏览集合页15s
  useEffect(() => {
    if(browseGoodType === BROSE_GOOD_TYPE.PAGE) {
      !browserTimer.current && goodsList.length && browseGoodsTimes()
      return () => browserTimer.current && clearInterval(browserTimer.current)
    }
  },[goodsList])

  const getGoodsList = async () => {
    const { data } = await API.getItemListByItemIds({ itemIds })
    setGoodsList(data?.list || [])
  }

  useDidShow(() => {
    // 重新回到页面开启倒计时
    if(browseGoodType === BROSE_GOOD_TYPE.PAGE && startTimer && usePercent.current < +browseTime) {
      browseGoodsTimes()
    }
    console.warn('回到该页面了')
    if (browseGoodType === BROSE_GOOD_TYPE.DETAIL && preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) >= browseTime) {
      onCompleteTask()
      currentItemId.current = ''
      preBrowseTime.current = null
    } else if(preBrowseTime.current) {
      commonToast(`未达到${browseTime}秒~`)
      currentItemId.current = ''
      preBrowseTime.current = null
    }
  })

  useDidHide(() => {
    // 页面关闭清除定时器
    if(browserTimer.curren) {
      clearInterval(browserTimer.current)
      setStartTimer(true)
    }
  })
  // 浏览记录
  const onCompleteTask = async(itemId) => {
    const { success } = await API.doCompleteTask({ taskType: browseConfig.taskType, itemId: currentItemId.current })
    if (success) {
      getGoodsList()
      commonToast('浏览成功')
    }
  }
  // 点击商品 跳转时处理
  const onOpenDetail = (itemId, collected) => {
    const handleFn = {
      [BROSE_GOOD_TYPE.PAGE]: () => {
        setStartTimer(true)
        clearInterval(browserTimer.current)
        return;
      },
      [BROSE_GOOD_TYPE.CLICK]: () => {
        currentItemId.current = itemId
        onCompleteTask()
      },
      [BROSE_GOOD_TYPE.DETAIL]: () => {
        if(collected) {
          commonToast('该商品已经浏览过了')
          return;
        }
        preBrowseTime.current = Date.now()
        currentItemId.current = itemId
      }
    }
    handleFn[browseGoodType]()
  }
  // 浏览页面定时器
  const browseGoodsTimes = () => {
    browserTimer.current = setInterval(() => {
      const keepTime_ = browseTime
      console.log('enter the browse time ');
      usePercent.current += 1
      setAccumulateTime(+keepTime_ - usePercent.current)
      console.warn(usePercent.current,keepTime_)
      if (usePercent.current >= keepTime_) {
        onCompleteTask()
        clearInterval(browserTimer.current)
        usePercent.current = 0
        setAccumulateTime(0)
      }
    }, 1000)
  }

  return (
    <View className={styles['page-container']}>
      <View className={styles['page-psd-container']} style={{ background: `url(${browseConfig.bg}) no-repeat`, backgroundSize: '750rpx 1624rpx' }}>
        <View className={styles['page-content']}>
          <View className={styles['page-content__title']}>
            <GoodsTitle config={browseConfig.head}/>
          </View>
          <View className={styles['page-content__list']}>
            <GoodsList count={accumulateTime} goodsList={goodsList} task={browseConfig} onOpenDetail={(itemId,collected) => onOpenDetail(itemId,collected)} />
          </View>
        </View>
      </View>
    </View>
  )
}

export default BrowseGoodsPage


