/** @format */

import { resultsModel } from '../../sdk'
import { recordErrorLog } from './logger'
import { CODE_TYPES } from '../../errorCode'
/** @format */

export async function doHandler(target: Object, method: IFunction, args: any[]) {
  let ret: IResult<any>
  try {
    ret = await method.apply(target, args)
  } catch (error) {
    console.log('error', error)
    recordErrorLog(args[0], args[1], error.toString(), error.stack)
    ret = resultsModel.error(CODE_TYPES.SYSTEM_ERROR)
  }
  return ret
}
