/** @format */

import { services } from '../decorator'
import { resultsModel } from '../sdk'
import { SellerService, TaobaoTopService, InstanceService } from '../service'
import { CODE_TYPES, TEMPLATE_INFO } from '../constants'
export default class BaseController {
  /**
   *  保存授权信息
   */
  @services([SellerService])
  async sellerSave(context: Context, {}, [sellerService]: [SellerService]) {
    let { openId, accessToken, appKey, userNick, appOwnerOpenId } = context

    let isPrimaryAccount: boolean = userNick.indexOf(':') === -1

    console.log(userNick, isPrimaryAccount, 'userNick------')

    // 子账号
    if (!isPrimaryAccount) {
      let primaryUserNick = userNick.split(':')[0]
      let sellerInfo = await sellerService.getSellerInfoByUserNick(primaryUserNick)
      if (sellerInfo) {
        accessToken = sellerInfo.accessToken
      }
    }

    // 已经有accessToken的记录 更新记录
    let hasSellerInfo = await sellerService.findSellerInfo(openId)

    if (hasSellerInfo) {
      await sellerService.updateSellerInfo(openId, { accessToken })
      return resultsModel.success(true)
    } else {
      // 新增记录
      let result = await sellerService.saveSellerInfo({
        accessToken,
        openId,
        appKey,
        userNick,
        appOwnerOpenId
      })
      return resultsModel.success(result)
    }
  }

  @services([SellerService, TaobaoTopService, InstanceService])
  async sellerSaasSave(
    context: Context,
    {},
    [sellerService, taobaoTopService, InstanceService]: [SellerService, TaobaoTopService, InstanceService]
  ) {
    let { openId, accessToken, appKey, userNick, appOwnerOpenId, consumeMiniAppId } = context
    let primaryAccountNick = userNick || 'duiba2'
    let isPrimaryAccount = true
    let primaryOpenId = openId
    let shopId = ''
    if (userNick && ~userNick.indexOf(':')) {
      let userNickArr = userNick.split(':')
      isPrimaryAccount = false
      primaryAccountNick = userNickArr[0]
      if (!isPrimaryAccount) {
        let sellerInfo = await sellerService.getSellerInfoByUserNick(primaryAccountNick)
        if (sellerInfo) {
          accessToken = sellerInfo.accessToken
          primaryOpenId = sellerInfo.openId
          shopId = sellerInfo.shopId
        } else {
          return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '请用主账号进入后台进行授权')
        }
      }
    }
    let hasResult = await sellerService.findSellerInfo(openId)
    let subInfo = await taobaoTopService.getSubRelationship(primaryAccountNick)
    let shopInfoResult = await taobaoTopService.getShopId()
    if (hasResult && hasResult[0]) {
      await sellerService.updateSellerInfo(openId, {
        accessToken
      })
      await InstanceService.updateInstanceInfo(openId, {
        accessToken
      })
      // return resultsModel.success({ deadline: subInfo.deadline || "" });
    } else {
      if (!shopInfoResult.success) {
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '获取淘宝店铺信息失败')
      }
      await sellerService.saveSellerInfo({
        accessToken,
        openId,
        appKey,
        // @ts-ignore
        shopId: shopInfoResult.data.sid,
        userNick,
        appOwnerOpenId
      })
      // return resultsModel.success({ deadline: subInfo.deadline || "" });
    }
    let instanceOldInfo = await InstanceService.getMiniAppInstanceInfoByNick(primaryAccountNick)
    if (!instanceOldInfo) {
      if (!isPrimaryAccount) {
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '请用主账号进入后台进行授权')
      }
      let instanceInfo = await taobaoTopService.getTemplateInstantiate()
      const { app_id, app_version } = instanceInfo
      if (instanceInfo) {
        let onlineInstance = await taobaoTopService.pushOnlineInstance({
          app_id,
          app_version
        })
        await InstanceService.saveInstanceInfo({
          ...instanceInfo,
          clients: onlineInstance.online_results.miniapp_instance_app_online_dto.reduce((s, v) => {
            return (s += v.client + ',')
          }, ''),
          ...onlineInstance.app_info,
          accessToken,
          template_version: TEMPLATE_INFO.template_version,
          template_id: TEMPLATE_INFO.template_id,
          openId,
          appKey,
          consumeMiniAppId,
          // @ts-ignore
          shopId: shopInfoResult.data.sid,
          userNick,
          appOwnerOpenId
        })
      } else {
        console.log('实例化信息获取失败')
      }
    } else {
      if (TEMPLATE_INFO.template_version !== instanceOldInfo.template_version) {
        const { clients, app_id, template_id } = instanceOldInfo
        let updateInfo = {
          clients,
          app_id,
          template_id,
          ext_json: {
            name: 'online'
          },
          template_version: TEMPLATE_INFO.template_version
        }
        let updateInstanceInfo = await taobaoTopService.updateMiniInstance(updateInfo)
        let onlineInstance = await taobaoTopService.pushOnlineInstance({
          app_id: updateInstanceInfo.app_id,
          app_version: updateInstanceInfo.app_version
        })
        await InstanceService.updateInstanceInfo(openId, {
          template_version: TEMPLATE_INFO.template_version,
          ...onlineInstance.app_info,
          app_version: updateInstanceInfo.app_version,
          pre_view_url: updateInstanceInfo.pre_view_url
        })
      }
      await InstanceService.updateInstanceInfo(openId, {
        // @ts-ignore
        shopId: shopInfoResult.data.sid
      })
      await InstanceService.updateInstanceInfo(primaryOpenId, {
        // @ts-ignore
        shopId: shopInfoResult.data.sid
      })
    }
    return resultsModel.success({ deadline: subInfo.deadline || '' })
  }
}
