"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setNewFollowUserData = exports.setNewVipUserData = exports.isNewVip = void 0;
var getToday_1 = require("./getToday");
/**
 * 判断是否新会员
 *
 * @format
 * @param {IUserInfo} userInfo
 * @param {IVipInfo} vipInfo
 * @returns {boolean}
 * @memberof UserService
 */
function isNewVip(userInfo, vipInfo) {
    var flag = userInfo.member.flag;
    var isVip = vipInfo.isVip;
    return !flag && isVip && !userInfo.member.newMember;
}
exports.isNewVip = isNewVip;
function setNewVipUserData(member) {
    var today = getToday_1.getToday();
    return __assign(__assign({}, member), { newMember: true, bememberTime: Date.now(), bememberDay: today });
}
exports.setNewVipUserData = setNewVipUserData;
function setNewFollowUserData(follow) {
    var today = getToday_1.getToday();
    return __assign(__assign({}, follow), { newFollow: true, followTime: Date.now(), followDay: today });
}
exports.setNewFollowUserData = setNewFollowUserData;
//# sourceMappingURL=userUpdate.js.map