"use strict";
/** @format */
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setTaskStatus = exports.getTodayCompleteTask = exports.getTotalCompleteTask = void 0;
var getToday_1 = require("./getToday");
var constants_1 = require("../../constants");
/**
 * 根据任务类型获取任务完成情况
 *
 * @param {IUserInfo} userInfo
 * @param {string} taskType
 * @returns {array}
 * @memberof TaskService
 */
function getTotalCompleteTask(taskType, userInfo) {
    var _a = userInfo.taskInfo, taskInfo = _a === void 0 ? {} : _a;
    var targetTaskList = [];
    Object.keys(taskInfo).forEach(function (day) {
        var _a, _b, _c, _d;
        if ((_a = taskInfo[day]) === null || _a === void 0 ? void 0 : _a[taskType]) {
            var dayTaskInfo = Array.isArray((_b = taskInfo[day]) === null || _b === void 0 ? void 0 : _b[taskType])
                ? (_c = taskInfo[day]) === null || _c === void 0 ? void 0 : _c[taskType] : [(_d = taskInfo[day]) === null || _d === void 0 ? void 0 : _d[taskType]];
            targetTaskList = __spreadArrays(targetTaskList, dayTaskInfo);
        }
    });
    return {
        completeTimes: (targetTaskList === null || targetTaskList === void 0 ? void 0 : targetTaskList.length) || 0,
        taskInfo: targetTaskList
    };
}
exports.getTotalCompleteTask = getTotalCompleteTask;
/**
 *
 * 获取任务今天完成的次数
 *
 * @param {string} taskType  任务类型
 * @param {IUserInfo} userInfo 用户信息
 * @returns {number} todayTimes  今日任务完成次数  todayTaskInfo  今日对应任务完成详情
 * @memberof TaskService
 */
function getTodayCompleteTask(taskType, userInfo) {
    var _a, _b, _c, _d, _e;
    var today = getToday_1.getToday();
    return {
        todayCompleteTimes: ((_c = (_b = (_a = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _a === void 0 ? void 0 : _a[today]) === null || _b === void 0 ? void 0 : _b[taskType]) === null || _c === void 0 ? void 0 : _c.length) || 0,
        todayTaskInfo: ((_e = (_d = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _d === void 0 ? void 0 : _d[today]) === null || _e === void 0 ? void 0 : _e[taskType]) || []
    };
}
exports.getTodayCompleteTask = getTodayCompleteTask;
/**
 *
 *  根据用户和任务完成情况,设置任务状态
 *
 * @param {IUserInfo} useInfo
 * @param {string} taskType
 * @param {number} taskRateType
 * @param {number} [limitTimesEverday] 每天限制次数 任务频率为每天的时候必填
 * @return {taskTatus} 1未完成 2 待领取 3 已完成
 * @memberof TaskService
 */
function setTaskStatus(useInfo, taskType, taskRateType, limitTimesEveryday) {
    var _a;
    if (limitTimesEveryday === void 0) { limitTimesEveryday = 1; }
    var waitReceive = ((_a = useInfo === null || useInfo === void 0 ? void 0 : useInfo.remainTimes) === null || _a === void 0 ? void 0 : _a[taskType]) || 0;
    if (waitReceive)
        return constants_1.TASK_STATUS.WAIT_RECEIVE;
    // 当天的完成次数
    var todayCompleteTimes = getTodayCompleteTask(taskType, useInfo).todayCompleteTimes;
    // 总共的完成次数
    var completeTimes = getTotalCompleteTask(taskType, useInfo).completeTimes;
    switch (taskRateType) {
        case constants_1.TASK_RATE_TYPE.FOREVER:
            return completeTimes > 0 ? constants_1.TASK_STATUS.DONE : constants_1.TASK_STATUS.WAIT_DO;
            break;
        case constants_1.TASK_RATE_TYPE.EVERYDAY:
            return todayCompleteTimes >= limitTimesEveryday ? constants_1.TASK_STATUS.DONE : constants_1.TASK_STATUS.WAIT_DO;
            break;
        case constants_1.TASK_RATE_TYPE.NOLIMIT:
            return constants_1.TASK_STATUS.WAIT_DO;
            break;
    }
}
exports.setTaskStatus = setTaskStatus;
//# sourceMappingURL=task.js.map