/** @format */
/**
 * 根据任务类型获取任务完成情况
 *
 * @param {IUserInfo} userInfo
 * @param {string} taskType
 * @returns {array}
 * @memberof TaskService
 */
export declare function getTotalCompleteTask(taskType: string, userInfo: IUserInfo): {
    completeTimes: number;
    taskInfo: ITaskDetail[];
};
/**
 *
 * 获取任务今天完成的次数
 *
 * @param {string} taskType  任务类型
 * @param {IUserInfo} userInfo 用户信息
 * @returns {number} todayTimes  今日任务完成次数  todayTaskInfo  今日对应任务完成详情
 * @memberof TaskService
 */
export declare function getTodayCompleteTask(taskType: string, userInfo: IUserInfo): {
    todayCompleteTimes: number;
    todayTaskInfo: ITaskDetail[];
};
/**
 *
 *  根据用户和任务完成情况,设置任务状态
 *
 * @param {IUserInfo} useInfo
 * @param {string} taskType
 * @param {number} taskRateType
 * @param {number} [limitTimesEverday] 每天限制次数 任务频率为每天的时候必填
 * @return {taskTatus} 1未完成 2 待领取 3 已完成
 * @memberof TaskService
 */
export declare function setTaskStatus(useInfo: IUserInfo, taskType: string, taskRateType: number, limitTimesEveryday?: number): number;
