/** @format */
import { CodeType } from 'taobao-mini-sdk/lib/utils/codetypes';
/**
 * 发奖，包含权益，实物，积分
 * @param {*} document 必须要有{ type, ename, _id }
 * @param {*} session
 * @param {*} context
 */
export declare const sendTBAward: (context: IContext<IParams>, session: string, awardInfo: IAwards) => Promise<IAwards | CodeType>;
/**
 * 发放积分
 * @param {发放的积分数} credits
 * @param {*} session
 * @param {*} context
 * @returns {drawStatus, remark}
 */
export declare const sendCredits: (credits: number, session: string, context: IContext<IParams>) => Promise<{
    drawStatus: number;
    remark: string;
}>;
/**
 * @desc 发放权益
 * @param {权益名称} ename
 * @param {唯一key} uniqueId
 * @param {*} session
 * @param {*} context
 * @returns { drawStatus, remark }
 */
export declare const sendEname: (ename: string, uniqueId: string, session: string, context: IContext<IParams>) => Promise<{
    remark: string;
    drawStatus: number;
}>;
