/** @format */
export declare function dbFindOne<T>(context: IContext<IParams>, dbName: string, query: IMongoQuery): Promise<T>;
export declare function dbFind<T>(context: IContext<IParams>, dbName: string, query: IMongoQuery): Promise<T[]>;
export declare function dbCount(context: IContext<IParams>, dbName: string, query: IMongoQuery): Promise<number>;
export declare function dbUpdate(context: IContext<IParams>, dbName: string, query: object, options?: IUpdateQuery): Promise<number>;
export declare function dbInsertOne(context: IContext<IParams>, dbName: string, document: any): Promise<string>;
export declare function dbInsertMany(context: IContext<IParams>, dbName: string, document: object[]): Promise<string[]>;
export declare function dbAggregate(context: IContext<IParams>, dbName: string, pipeline: object | object[], options?: object): Promise<any>;
