"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.lockUpdate = void 0;
var constants_1 = require("../../constants");
/**
 * 并发更新
 * @param {接收数组或对象} daoqueryArr : [{dao: userdao, query:{_id:_id}}, {dao: activityprizedao, query: {userNick, status ...}}]
 * @param {*} fn
 * @param {*} times
 */
exports.lockUpdate = function (daoqueryArr, fn, times) {
    if (times === void 0) { times = 5; }
    return __awaiter(void 0, void 0, void 0, function () {
        function waitFor(ms) {
            return new Promise(function (resolve) {
                setTimeout(resolve, ms);
            });
        }
        var error, i, daoquery, time, success, updateRes, ret, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (typeof daoqueryArr !== 'object') {
                        console.log("lockUpdate \u53C2\u6570\u9519\u8BEF");
                        return [2 /*return*/, false];
                    }
                    if (!(daoqueryArr instanceof Array)) {
                        daoqueryArr = [daoqueryArr];
                    }
                    error = false;
                    for (i = 0; i < daoqueryArr.length; i++) {
                        daoquery = daoqueryArr[i];
                        if (!daoquery.dao || !daoquery.query) {
                            error = true;
                            console.log("daoquery", daoquery);
                            break;
                        }
                    }
                    if (error) {
                        throw Error("\u8C03\u7528lockUpdate\u65B9\u6CD5\u53C2\u6570\u4E0D\u7B26\u5408\u89C4\u8303");
                    }
                    time = 0;
                    console.log("\u8FDB\u5165update\u5E76\u53D1\u5904\u7406\u6B21\u6570", times);
                    success = false;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 10, , 12]);
                    _a.label = 2;
                case 2:
                    if (!(time++ < times && !success)) return [3 /*break*/, 9];
                    return [4 /*yield*/, lock(daoqueryArr)];
                case 3:
                    updateRes = _a.sent();
                    console.log("updateRes", updateRes);
                    if (!updateRes.every(function (v) { return v === 1; })) return [3 /*break*/, 6];
                    return [4 /*yield*/, fn()];
                case 4:
                    ret = _a.sent();
                    console.log("\u5B8C\u6210\u8C03\u7528\uFF0C\u89E3\u9501\u64CD\u4F5C\u6267\u884C--------------");
                    return [4 /*yield*/, unLock(daoqueryArr)];
                case 5:
                    _a.sent();
                    success = true;
                    return [2 /*return*/, ret];
                case 6:
                    console.log("\u8FDB\u5165waitFor\u4E86\uFF0C\u9700\u7B49\u5F8530ms");
                    return [4 /*yield*/, waitFor(30)];
                case 7:
                    _a.sent();
                    success = false;
                    _a.label = 8;
                case 8: return [3 /*break*/, 2];
                case 9: return [3 /*break*/, 12];
                case 10:
                    e_1 = _a.sent();
                    console.log(e_1);
                    return [4 /*yield*/, unLock(daoqueryArr)];
                case 11:
                    _a.sent();
                    success = true;
                    return [3 /*break*/, 12];
                case 12:
                    console.log("daoqueryArr", daoqueryArr);
                    if (!!success) return [3 /*break*/, 14];
                    return [4 /*yield*/, unLock(daoqueryArr)];
                case 13:
                    _a.sent();
                    return [2 /*return*/, constants_1.CODE_TYPES.ERROR_UPDATE_RETRY];
                case 14: return [2 /*return*/];
            }
        });
    });
};
function unLock(daoqueryArr) {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, daoqueryArr.reduce(function (prev, daoquery) { return __awaiter(_this, void 0, void 0, function () {
                        var ures;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, daoquery.dao.update(daoquery.query, { $set: { lockStatus: 1 } })];
                                case 1:
                                    ures = _a.sent();
                                    console.log("\u66F4\u65B0lockStatus\u4E3A1", ures);
                                    prev.push(ures);
                                    return [2 /*return*/, prev];
                            }
                        });
                    }); }, [])];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function lock(daoqueryArr) {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, daoqueryArr.reduce(function (prev, daoquery) { return __awaiter(_this, void 0, void 0, function () {
                        var ures;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    console.log("daoquery", daoquery);
                                    return [4 /*yield*/, daoquery.dao.update(daoquery.query, { $set: { lockStatus: 2 } })];
                                case 1:
                                    ures = _a.sent();
                                    console.log("\u66F4\u65B0lockStatus\u4E3A2", ures);
                                    prev.push(ures);
                                    return [2 /*return*/, prev];
                            }
                        });
                    }); }, [])];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
/**
 * 调用示例
 */
// 扣库存
// let res = await lockUpdate({dao: this.activityprizedao, query: {_id}}, async ()=> {
//   return await this.activityprizedao.update({_id}, {$set: {
//     useStock: useStock + 1,
//     updateTime: Date.now()
//   }});
// });
// console.log(res);
// if (!res) {
//   return CODE_TYPES.ERROR_UPDATE_RETRY;
// }
// return true;
//# sourceMappingURL=lockUpdate.js.map