"use strict";
/**
 * 用户购买记录查询
 *
 * @format
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserOrderlist = void 0;
var dayjs = require("dayjs");
var sdk_1 = require("../../sdk");
var getSession_1 = require("./getSession");
var constants_1 = require("../../constants");
exports.getUserOrderlist = function (context, queryStartTime, queryEndTime, session) { return __awaiter(void 0, void 0, void 0, function () {
    var results_1, currentTime, lastUpdateTime, params, orderResult, trade, e_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 4, , 5]);
                results_1 = [];
                currentTime = Date.now();
                lastUpdateTime = dayjs().add(-3, 'month').valueOf();
                console.log("lastUpdateTime", lastUpdateTime);
                // 若倒推的3个月时间小于传入的查询开始时间, 则以查询开始时间作为最后更新时间
                if (lastUpdateTime < queryStartTime) {
                    lastUpdateTime = queryStartTime;
                }
                if (!!session) return [3 /*break*/, 2];
                return [4 /*yield*/, getSession_1.getSellerSession(context)];
            case 1:
                session = (_a.sent()).session;
                _a.label = 2;
            case 2:
                params = {
                    startTime: sdk_1.dateFormatter(sdk_1.transformBeijingDate(lastUpdateTime)),
                    endTime: sdk_1.dateFormatter(sdk_1.transformBeijingDate(queryEndTime || currentTime)),
                    openId: context.openId,
                    session: session
                };
                return [4 /*yield*/, sdk_1.TBAPIS.getBuyerOrderList(context, params)];
            case 3:
                orderResult = _a.sent();
                if (orderResult.total_results > 0) {
                    trade = orderResult.trades.trade;
                    trade.forEach(function (i) {
                        var _a, _b;
                        if (constants_1.TAOBAO_SUCCESS_ORDER_STATUS.includes(i.status)) {
                            (_b = (_a = i === null || i === void 0 ? void 0 : i.orders) === null || _a === void 0 ? void 0 : _a.order) === null || _b === void 0 ? void 0 : _b.forEach(function (s) {
                                results_1.push({
                                    payTime: i.pay_time,
                                    itemId: s.num_iid,
                                    time: i.created,
                                    price: s.price,
                                    orderId: s.oid,
                                    img: s.pic_path,
                                    title: s.title,
                                    tId: i.tid
                                });
                            });
                        }
                    });
                }
                console.log("\u5DF2\u652F\u4ED8\u7684\u8BA2\u5355\u5217\u8868", results_1);
                return [2 /*return*/, results_1];
            case 4:
                e_1 = _a.sent();
                console.log("\u9519\u8BEF", e_1);
                return [2 /*return*/, []];
            case 5: return [2 /*return*/];
        }
    });
}); };
//# sourceMappingURL=getUserOrderlist.js.map