"use strict";
/** @format */
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatUpdatedDataByProjection = exports.formatUserNick = exports.formatUpdateUserProjection = void 0;
var lodash_1 = require("lodash");
var mpath_1 = require("mpath");
/**
 *  updateUser projection 格式化
 *
 * @format
 * @param {object} projection
 * @return {*}
 * @memberof UserService
 */
function formatUpdateUserProjection(projection) {
    projection['$set'] = projection['$set'] || {};
    projection['$set'].updateTime = Date.now();
    // $push不存在属性  删除$push
    if (projection['$push'] && !Object.keys(projection['$push']).length) {
        delete projection['$push'];
    }
    console.log(projection);
    return projection;
}
exports.formatUpdateUserProjection = formatUpdateUserProjection;
// 用户昵称脱敏
function formatUserNick(name, replaceStr) {
    if (replaceStr === void 0) { replaceStr = '***'; }
    var newStr;
    if (name.length === 2) {
        newStr = name.substr(0, 1) + replaceStr + name.substr(-1, 1);
    }
    else if (name.length > 2) {
        var char = replaceStr;
        newStr = name.substr(0, 1) + char + name.substr(-1, 1);
    }
    else {
        newStr = name + replaceStr;
    }
    return newStr;
}
exports.formatUserNick = formatUserNick;
/**
 *  不通过数据库select的情况下 获取更新后的数据
 *
 * @export
 * @param {IUserInfo} userInfo
 * @param {IDecoratorUpdateQuery} projection
 */
function formatUpdatedDataByProjection(dbData, projection) {
    var updatedDbData = lodash_1.assign({}, dbData);
    if (!lodash_1.isEmpty(projection.$set)) {
        Object.keys(projection.$set).forEach(function (key) {
            var _a;
            mpath_1.set(key, (_a = projection.$set) === null || _a === void 0 ? void 0 : _a[key], updatedDbData);
        });
    }
    if (!lodash_1.isEmpty(projection.$inc)) {
        Object.keys(projection.$inc).forEach(function (key) {
            var _a;
            var originValue = mpath_1.get(key, updatedDbData) || 0;
            mpath_1.set(key, ((_a = projection.$inc) === null || _a === void 0 ? void 0 : _a[key]) + originValue, updatedDbData);
        });
        updatedDbData = lodash_1.merge({}, dbData, projection.$set);
    }
    if (!lodash_1.isEmpty(projection.$push)) {
        Object.keys(projection.$push).forEach(function (key) {
            var _a;
            var originValue = mpath_1.get(key, updatedDbData) || [];
            mpath_1.set(key, __spreadArrays(originValue, [(_a = projection.$push) === null || _a === void 0 ? void 0 : _a[key], updatedDbData]));
        });
    }
    return updatedDbData;
}
exports.formatUpdatedDataByProjection = formatUpdatedDataByProjection;
//# sourceMappingURL=format.js.map