"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkValidEnamePrize = exports.checkValidObjectPrize = void 0;
var sdk_1 = require("../../../sdk");
var errorCode_1 = require("../../../errorCode");
var constants_1 = require("../../../constants");
var mongodb_1 = require("../mongodb");
var db_1 = require("../../../db");
function checkValidPrize(prizeTypes) {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            return [2 /*return*/, function (context, _a) {
                    var activityInfo = _a.activityInfo;
                    return __awaiter(_this, void 0, void 0, function () {
                        var id, awardInfo;
                        return __generator(this, function (_b) {
                            switch (_b.label) {
                                case 0:
                                    id = context.data.id;
                                    return [4 /*yield*/, mongodb_1.dbFindOne(context, db_1.AWARDS_DB_NAME, {
                                            _id: id
                                        })];
                                case 1:
                                    awardInfo = _b.sent();
                                    console.log("receive-award", awardInfo);
                                    // 奖品不存在
                                    if (!awardInfo) {
                                        return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.ERROR_NO_PRIZE)];
                                    }
                                    // 不是校验的奖品类型，非法操作
                                    if (!prizeTypes.includes(awardInfo.type)) {
                                        return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.ERROR_FORBIDDEN_OPE)];
                                    }
                                    // 状态不是1,6
                                    if (![constants_1.DRAW_STATUS.WAITAWARD, constants_1.DRAW_STATUS.RETRY].includes(awardInfo.drawStatus)) {
                                        return [2 /*return*/, errorCode_1.CODE_TYPES.ERROR_FORBIDDEN_OPE];
                                    }
                                    return [2 /*return*/, {
                                            awardInfo: awardInfo
                                        }];
                            }
                        });
                    });
                }];
        });
    });
}
exports.default = checkValidPrize;
function checkValidObjectPrize(context, _a) {
    var activityInfo = _a.activityInfo;
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, checkValidPrize([constants_1.PRIZE_TYPE.OBJECT])];
                case 1: return [2 /*return*/, _b.sent()];
            }
        });
    });
}
exports.checkValidObjectPrize = checkValidObjectPrize;
function checkValidEnamePrize(context, _a) {
    var activityInfo = _a.activityInfo;
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, checkValidPrize([constants_1.PRIZE_TYPE.ENAME, constants_1.PRIZE_TYPE.CREDITS])];
                case 1: return [2 /*return*/, _b.sent()];
            }
        });
    });
}
exports.checkValidEnamePrize = checkValidEnamePrize;
//# sourceMappingURL=checkValidPrize.js.map