"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkGameTimes = void 0;
var lodash_1 = require("lodash");
var mpath_1 = require("mpath");
var errorCode_1 = require("../../../errorCode");
var sdk_1 = require("../../../sdk");
function checkUserInfo(gameLimit, errorMsg) {
    var _this = this;
    return function (context, _a) {
        var userInfo = _a.userInfo;
        return __awaiter(_this, void 0, void 0, function () {
            var allValid;
            return __generator(this, function (_b) {
                console.log(gameLimit);
                allValid = validateData(userInfo, gameLimit);
                if (!allValid)
                    return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.SYSTEM_ERROR, errorMsg)];
                console.log(allValid);
                return [2 /*return*/];
            });
        });
    };
}
exports.default = checkUserInfo;
function checkGameTimes(count) {
    return checkUserInfo({ gameTimes: { $gte: count } }, '游戏次数不足');
}
exports.checkGameTimes = checkGameTimes;
function validateData(data, condition) {
    if (data === void 0) { data = {}; }
    var allValid = true;
    Object.keys(condition).forEach(function (key) {
        var value = condition === null || condition === void 0 ? void 0 : condition[key];
        if (lodash_1.isString(value) || lodash_1.isBoolean(value) || lodash_1.isNumber(value)) {
            allValid = validateEq(data, key, value);
        }
        if (lodash_1.isObject(value)) {
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$eq) && (allValid = validateEq(data, key, value === null || value === void 0 ? void 0 : value.$eq));
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$gt) && (allValid = validateGt(data, key, value === null || value === void 0 ? void 0 : value.$gt));
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$gte) && (allValid = validateGte(data, key, value === null || value === void 0 ? void 0 : value.$gte));
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$lte) && (allValid = validateLte(data, key, value === null || value === void 0 ? void 0 : value.$lte));
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$lt) && (allValid = validateLt(data, key, value === null || value === void 0 ? void 0 : value.$lt));
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$in) && (allValid = validateIn(data, key, value === null || value === void 0 ? void 0 : value.$in));
            !lodash_1.isUndefined(value === null || value === void 0 ? void 0 : value.$ne) && (allValid = validateNe(data, key, value === null || value === void 0 ? void 0 : value.$ne));
        }
    });
    return allValid;
}
function validateEq(data, key, value) {
    if (data === void 0) { data = {}; }
    return mpath_1.get(key, data) === value;
}
function validateGt(data, key, value) {
    if (data === void 0) { data = {}; }
    return mpath_1.get(key, data) > value;
}
function validateGte(data, key, value) {
    if (data === void 0) { data = {}; }
    return mpath_1.get(key, data) >= value;
}
function validateLt(data, key, value) {
    if (data === void 0) { data = {}; }
    console.log(mpath_1.get(key, data));
    return mpath_1.get(key, data) < value;
}
function validateLte(data, key, value) {
    if (data === void 0) { data = {}; }
    return mpath_1.get(key, data) <= value;
}
function validateIn(data, key, value) {
    if (data === void 0) { data = {}; }
    return value.includes(mpath_1.get(key, data));
}
function validateNe(data, key, value) {
    if (data === void 0) { data = {}; }
    return mpath_1.get(key, data) !== value;
}
//# sourceMappingURL=checkUserInfo.js.map