"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../../../sdk");
var errorCode_1 = require("../../../errorCode");
var task_1 = require("../task");
var constants_1 = require("../../../constants");
function checkTaskLimit(context, _a) {
    var _b, _c, _d;
    var userInfo = _a.userInfo, activityInfo = _a.activityInfo;
    return __awaiter(this, void 0, void 0, function () {
        var _e, taskType, itemId, itemIds, itemIdArray, _f, taskRateType, times, completeTimes, hasComplete, _g, todayCompleteTimes, todayTaskInfo, hasCompleteToday, itemHasCompleteToday;
        return __generator(this, function (_h) {
            _e = context.data, taskType = _e.taskType, itemId = _e.itemId;
            itemIds = (((_b = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _b === void 0 ? void 0 : _b[taskType]) || {}).itemIds;
            if (!taskType) {
                console.error('使用checkTaskLimit， 云函数必须传入taskType参数');
                return [2 /*return*/];
            }
            if (!((_c = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _c === void 0 ? void 0 : _c[taskType])) {
                return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.SYSTEM_ERROR, "\u8BE5\u6D3B\u52A8\u7F3A\u5C11" + taskType + "\u914D\u7F6E\u9879")];
            }
            if (itemId && !itemIds) {
                return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.SYSTEM_ERROR, "\u8BE5\u4EFB\u52A1\u7F3A\u5C11\u5546\u54C1\u914D\u7F6E\u9879")];
            }
            // B端配置商品ids不匹配正确
            if (itemId && itemIds) {
                itemIdArray = Array.isArray(itemIds) ? itemIds : itemIds.split(',').map(function (v) { return +v; });
                if (!itemIdArray.includes(+itemId))
                    return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.PARAMS_ERROR, '商品id不匹配')];
            }
            _f = (_d = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _d === void 0 ? void 0 : _d[taskType], taskRateType = _f.taskRateType, times = _f.times;
            completeTimes = task_1.getTotalCompleteTask(taskType, userInfo).completeTimes;
            hasComplete = completeTimes && taskRateType === constants_1.TASK_RATE_TYPE.FOREVER;
            if (hasComplete)
                return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.ERROR_TASK_LIMIT, "\u8BE5\u4EFB\u52A1\u5DF2\u5B8C\u6210\uFF0C\u53BB\u770B\u770B\u5176\u5B83\u4EFB\u52A1\u5427~")
                    // 每日任务今天已经完成
                ];
            _g = task_1.getTodayCompleteTask(taskType, userInfo), todayCompleteTimes = _g.todayCompleteTimes, todayTaskInfo = _g.todayTaskInfo;
            hasCompleteToday = times && todayCompleteTimes === times && taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY;
            if (hasCompleteToday) {
                return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.ERROR_TASK_LIMIT, "\u8BE5\u4EFB\u52A1\u4ECA\u5929\u5DF2\u5B8C\u6210\uFF0C\u660E\u5929\u518D\u6765\u5427~")];
            }
            itemHasCompleteToday = todayTaskInfo.find(function (v) { return v.itemId && v.itemId === itemId; }) && taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY;
            if (itemHasCompleteToday) {
                return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.PARAMS_ERROR, '今日该商品任务已完成')];
            }
            return [2 /*return*/];
        });
    });
}
exports.default = checkTaskLimit;
//# sourceMappingURL=checkTaskLimit.js.map