"use strict";
/**
 * 任务相关方法
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var user_service_1 = require("./user.service");
var utils_1 = require("../../utils");
var constants_1 = require("../../constants");
var task_1 = require("../../utils/common/task");
var errorCode_1 = require("../../errorCode");
var TaskService = /** @class */ (function (_super) {
    __extends(TaskService, _super);
    function TaskService(context) {
        return _super.call(this, context) || this;
    }
    // 根据活动tasks字段渲染任务
    TaskService.prototype.initTaskList = function (userInfo, activityInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, {
                        list: Object.keys((activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) || {}).map(function (task) {
                            var _a, _b;
                            return _this.initTask(task, (_b = (_a = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _a === void 0 ? void 0 : _a[task]) === null || _b === void 0 ? void 0 : _b.title, userInfo, activityInfo);
                        })
                    }];
            });
        });
    };
    /**
     *  根据任务类型初始化   b端 tasks字段必须有相应的配置
     *
     * @param {ITaskType} taskType 任务类型
     * @param {string} title 任务标题
     * @param {IActivityInfo} activityInfo 任务配置
     * @param {IUserInfo} userInfo 用户信息
     * @return {ITaskInfo}  {ITaskInfo} 任务信息
     * @memberof TaskService
     */
    TaskService.prototype.initTask = function (taskType, title, userInfo, activityInfo) {
        var _a, _b;
        if (!((_a = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _a === void 0 ? void 0 : _a[taskType])) {
            console.error("\u6D3B\u52A8\u7F3A\u5C11" + taskType + "\u4EFB\u52A1\u914D\u7F6E\u9879");
        }
        var _c = ((_b = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _b === void 0 ? void 0 : _b[taskType]) || {}, value = _c.value, _d = _c.itemIds, itemIds = _d === void 0 ? '' : _d, taskRateType = _c.taskRateType, _e = _c.times, times = _e === void 0 ? 1 : _e, _f = _c.link, link = _f === void 0 ? '' : _f;
        var remainTimes = userInfo.remainTimes;
        var todayCompleteTimes = task_1.getTodayCompleteTask(taskType, userInfo).todayCompleteTimes;
        var completeTimes = task_1.getTotalCompleteTask(taskType, userInfo).completeTimes;
        return {
            taskType: taskType,
            title: title,
            itemIds: itemIds,
            rewards: value,
            taskRateType: taskRateType,
            times: times,
            url: taskType === 'member' ? utils_1.generateVipUrl(utils_1.formatVipCbUrl(this.context)) : link,
            todayCompleteTimes: todayCompleteTimes,
            completeTimes: completeTimes,
            status: task_1.setTaskStatus(userInfo, taskType, taskRateType, times),
            waitReceive: remainTimes === null || remainTimes === void 0 ? void 0 : remainTimes[taskType]
        };
    };
    /**
     *
     * 领取任务奖励
     *
     * @param {ITaskType} taskType
     * @param {string} awardsTargetKey
     * @param {IUserInfo} userInfo
     * @return {number} rewards
     * @memberof TaskService
     */
    TaskService.prototype.receiveTaskRewards = function (taskType, awardsTargetKey, userInfo) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var waitReceiveTimes;
            var _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        waitReceiveTimes = (_a = userInfo === null || userInfo === void 0 ? void 0 : userInfo.remainTimes) === null || _a === void 0 ? void 0 : _a[taskType];
                        return [4 /*yield*/, this.updateUser(userInfo._id, {
                                $set: (_b = {},
                                    _b["remainTimes." + taskType] = 0,
                                    _b),
                                $inc: (_c = {},
                                    _c[awardsTargetKey] = waitReceiveTimes,
                                    _c)
                            })];
                    case 1:
                        _d.sent();
                        return [2 /*return*/, {
                                rewards: waitReceiveTimes
                            }];
                }
            });
        });
    };
    /**
     *根据任务类型更新任务待领取次数和任务记录
     *
     * @param {string} taskType
     * @param {number} activityInfo
     * @param {IActivityInfo} userInfo
     * @returns {boolean}
     * @memberof TaskService
     */
    TaskService.prototype.completeTask = function (taskType, activityInfo, userInfo, customRecord) {
        var _a, _b;
        if (customRecord === void 0) { customRecord = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var today, rewards, _c, openId, itemId, record, result;
            var _d, _e;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        today = utils_1.getToday();
                        rewards = ((_b = (_a = activityInfo === null || activityInfo === void 0 ? void 0 : activityInfo.tasks) === null || _a === void 0 ? void 0 : _a[taskType]) === null || _b === void 0 ? void 0 : _b.value) || 0;
                        _c = this.context, openId = _c.openId, itemId = _c.data.itemId;
                        record = __assign({ itemId: itemId, openId: taskType === 'invites' ? openId : undefined }, customRecord);
                        return [4 /*yield*/, this.updateUser(userInfo._id, {
                                $inc: (_d = {},
                                    _d["remainTimes." + taskType] = rewards,
                                    _d),
                                $push: (_e = {},
                                    _e["taskInfo." + today + "." + taskType] = __assign(__assign({}, record), { createTime: Date.now() }),
                                    _e)
                            })];
                    case 1:
                        result = _f.sent();
                        return [2 /*return*/, result ? { ok: 1 } : errorCode_1.CODE_TYPES.ERROR_DO_TASK];
                }
            });
        });
    };
    // 根据下单下单记录,更新状态
    TaskService.prototype.updateOrderGoodsTask = function (userInfo, tasks, activityStartTime, session) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            var taskType, _c, _d, _e, value, itemIds, taskRateType, times, _f, completeTimes, taskInfo, todayCompleteTimes, today, orderResult, itemIdsArr, projection, targetOrders;
            var _g;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        taskType = 'orderGoods';
                        _c = tasks, _d = taskType, _e = _c[_d], value = _e.value, itemIds = _e.itemIds, taskRateType = _e.taskRateType, times = _e.times;
                        _f = task_1.getTotalCompleteTask(taskType, userInfo), completeTimes = _f.completeTimes, taskInfo = _f.taskInfo;
                        todayCompleteTimes = task_1.getTodayCompleteTask(taskType, userInfo).todayCompleteTimes;
                        // 永久任务且已完成
                        if (taskRateType === constants_1.TASK_RATE_TYPE.FOREVER && completeTimes) {
                            return [2 /*return*/, {}];
                        }
                        today = utils_1.getToday();
                        if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && todayCompleteTimes >= times) {
                            return [2 /*return*/, {}];
                        }
                        return [4 /*yield*/, utils_1.getUserOrderlist(this.context, 
                            //@ts-ignore
                            activityStartTime || Date.now(), Date.now(), session)];
                    case 1:
                        orderResult = _h.sent();
                        itemIdsArr = itemIds.split(',').map(function (v) { return +v; });
                        projection = {
                            $inc: (_g = {},
                                _g["remainTimes." + taskType] = 0,
                                _g),
                            $set: {}
                        };
                        targetOrders = ((_b = (_a = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _a === void 0 ? void 0 : _a[today]) === null || _b === void 0 ? void 0 : _b[taskType]) || [];
                        orderResult.forEach(function (v) {
                            // @ts-ignore
                            // 商品订单包含目标商品 且orderId为新订单
                            if (itemIdsArr.includes(v.itemId) && !taskInfo.some(function (order) { return order.orderId === v.orderId; })) {
                                if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && targetOrders.length >= times) {
                                    return;
                                }
                                projection.$inc["remainTimes." + taskType] += +value;
                                targetOrders.push({
                                    itemId: v.itemId,
                                    orderId: v.orderId,
                                    payTime: v.payTime,
                                    createTime: Date.now()
                                });
                            }
                            if (targetOrders === null || targetOrders === void 0 ? void 0 : targetOrders.length) {
                                projection.$set["taskInfo." + today + "." + taskType] = targetOrders;
                            }
                        });
                        return [2 /*return*/, projection];
                }
            });
        });
    };
    TaskService.prototype.getItemListWithCollectStatus = function (list, userInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var taskInfo;
            return __generator(this, function (_a) {
                taskInfo = task_1.getTotalCompleteTask('collectGoods', userInfo).taskInfo;
                return [2 /*return*/, list.list.map(function (v) {
                        return __assign(__assign({}, v), { 
                            // 完成列表是否含有itemId
                            collected: taskInfo.some(function (completeItem) { return completeItem.itemId === v.itemId; }) });
                    })];
            });
        });
    };
    return TaskService;
}(user_service_1.default));
exports.default = TaskService;
//# sourceMappingURL=task.service.js.map