/**
 * 任务相关方法
 *
 * @format
 */
import UserService from './user.service';
export interface ITaskInfo {
    taskType?: string;
    url?: string;
    rewards: number;
    itemIds?: string;
    todayCompleteTimes?: number;
    completeTimes?: number;
    taskRateType: number;
    times?: number;
    waitReceive?: number;
    title: string;
    status: number;
}
export default class TaskService extends UserService {
    constructor(context: IContext<IParams>);
    initTaskList(userInfo: IUserInfo, activityInfo: IActivityInfo): Promise<{
        list: ITaskInfo[];
    }>;
    /**
     *  根据任务类型初始化   b端 tasks字段必须有相应的配置
     *
     * @param {ITaskType} taskType 任务类型
     * @param {string} title 任务标题
     * @param {IActivityInfo} activityInfo 任务配置
     * @param {IUserInfo} userInfo 用户信息
     * @return {ITaskInfo}  {ITaskInfo} 任务信息
     * @memberof TaskService
     */
    initTask(taskType: ITaskType, title: string, userInfo: IUserInfo, activityInfo: IActivityInfo): ITaskInfo;
    /**
     *
     * 领取任务奖励
     *
     * @param {ITaskType} taskType
     * @param {string} awardsTargetKey
     * @param {IUserInfo} userInfo
     * @return {number} rewards
     * @memberof TaskService
     */
    receiveTaskRewards(taskType: ITaskType, awardsTargetKey: string, userInfo: IUserInfo): Promise<{
        rewards: number;
    }>;
    /**
     *根据任务类型更新任务待领取次数和任务记录
     *
     * @param {string} taskType
     * @param {number} activityInfo
     * @param {IActivityInfo} userInfo
     * @returns {boolean}
     * @memberof TaskService
     */
    completeTask(taskType: ITaskType, activityInfo: IActivityInfo, userInfo: IUserInfo, customRecord?: Object): Promise<{
        code: string;
        defaultMsg: string;
    } | {
        ok: number;
    }>;
    updateOrderGoodsTask(userInfo: IUserInfo, tasks: ITasks, activityStartTime: number, session?: string): Promise<{}>;
    getItemListWithCollectStatus(list: {
        list: ITaoBaoItems[];
    }, userInfo: IUserInfo): Promise<{
        collected: boolean;
        itemId: string;
        name: string;
        price: string;
        url: string;
        image: string;
        desc: string;
    }[]>;
}
