"use strict";
/**
 * 基本信息
 *
 * @format
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../../sdk");
var db_1 = require("../../db");
var xlsx = require("node-xlsx");
var utils_1 = require("../../utils");
var constants_1 = require("../../constants");
var StatService = /** @class */ (function () {
    function StatService(context) {
        this.context = context;
        this.statdao = new sdk_1.BaseDao(context, db_1.STAT_DB_NAME);
        this.accessdao = new sdk_1.BaseDao(context, db_1.ACCESS_DB_NAME);
        this.userdao = new sdk_1.BaseDao(context, db_1.USER_DB_NAME);
        this.awardsdao = new sdk_1.BaseDao(context, db_1.AWARDS_DB_NAME);
    }
    /**
     *  添加数据统计记录
     *
     * @param {number} type  数据类型
     * @param {object} [customStatData={}] 自定义数据
     * @param {IUserInfo} [userInfo] 用户信息
     * @return {boolean}
     * @memberof StatService
     */
    StatService.prototype.addStat = function (type, userInfo, customStatData) {
        if (userInfo === void 0) { userInfo = {}; }
        if (customStatData === void 0) { customStatData = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var openId, activityId, userNick, id;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        openId = this.context.openId;
                        activityId = this.context.data.activityId;
                        userNick = userInfo.userNick;
                        return [4 /*yield*/, this.statdao.insertOne(__assign(__assign({ activityId: activityId,
                                type: type, typeName: constants_1.STAT_TYPE[type], userNick: userNick,
                                openId: openId }, customStatData), { createTime: Date.now(), createDay: utils_1.getToday() }))];
                    case 1:
                        id = _a.sent();
                        return [2 /*return*/, { id: id }];
                }
            });
        });
    };
    StatService.prototype.getStats = function (activityId, startDay, endDay) {
        return __awaiter(this, void 0, void 0, function () {
            var day, oneDay, xlsxData, curDayTimestamp, endDayTimestamp, PV, UV, newUV, newUVFromInviteUV, vipPV, vipUV, noVipPV, noVipUV, newVipUV, newFollowUV, helpSuccessUV, getTaskCompleteUV, keyValueMapper, tommorrow;
            var _a, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        day = startDay;
                        oneDay = 24 * 3600 * 1000;
                        xlsxData = [];
                        curDayTimestamp = new Date(day).getTime();
                        endDayTimestamp = new Date(endDay).getTime();
                        _c.label = 1;
                    case 1:
                        if (!(curDayTimestamp <= endDayTimestamp)) return [3 /*break*/, 13];
                        return [4 /*yield*/, this.accessdao.count({ activityId: activityId, createDay: day })
                            // 访问UV
                        ];
                    case 2:
                        PV = _c.sent();
                        return [4 /*yield*/, this.userdao.count((_a = { activityId: activityId }, _a["login." + day] = { $exists: true }, _a))
                            // 新增UV
                        ];
                    case 3:
                        UV = _c.sent();
                        return [4 /*yield*/, this.userdao.count({ activityId: activityId, createDay: day })
                            // 新增UV(通过邀请)
                        ];
                    case 4:
                        newUV = _c.sent();
                        return [4 /*yield*/, this.userdao.count({ activityId: activityId, createDay: day, inviteId: { $exists: true } })
                            // 已入会(老会员)PV
                        ];
                    case 5:
                        newUVFromInviteUV = _c.sent();
                        return [4 /*yield*/, this.accessdao.count({
                                activityId: activityId,
                                createDay: day,
                                //@ts-ignore
                                $or: [{ 'member.flag': true }, { 'member.newMember': true }],
                                'member.bememberDay': { $not: { $eq: day } }
                            })
                            // 已入会(老会员)UV
                        ];
                    case 6:
                        vipPV = _c.sent();
                        return [4 /*yield*/, this.userdao.count((_b = {
                                    activityId: activityId
                                },
                                _b["login." + day] = { $exists: true },
                                _b.$or = [
                                    //@ts-ignore
                                    { 'member.flag': true },
                                    //@ts-ignore
                                    { 'member.newMember': true, 'member.bememberTime': { $lt: new Date(day).getTime() } }
                                ],
                                _b))
                            // 未入会PV
                        ];
                    case 7:
                        vipUV = _c.sent();
                        return [4 /*yield*/, this.accessdao.count({ activityId: activityId, createDay: day, isVip: false })
                            // 未入会UV
                        ];
                    case 8:
                        noVipPV = _c.sent();
                        return [4 /*yield*/, this.accessdao.aggregate([
                                { $match: { activityId: activityId, createDay: day, isVip: false } },
                                { $project: { openId: true } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 9:
                        noVipUV = (_c.sent()).length;
                        return [4 /*yield*/, this.userdao.count({ activityId: activityId, 'member.newMember': true, 'member.bememberDay': day })];
                    case 10:
                        newVipUV = _c.sent();
                        return [4 /*yield*/, this.userdao.count({ activityId: activityId, 'follow.newFollow': true, 'follow.followDay': day })
                            // 助力成功UV
                        ];
                    case 11:
                        newFollowUV = _c.sent();
                        return [4 /*yield*/, this.statdao.aggregate([
                                { $match: { activityId: activityId, createDay: day, type: constants_1.STAT_TYPE.INITE_SUCCESS } },
                                { $project: { openId: true } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 12:
                        helpSuccessUV = (_c.sent()).length;
                        getTaskCompleteUV = function (task, day) { return __awaiter(_this, void 0, void 0, function () {
                            var _a;
                            return __generator(this, function (_b) {
                                switch (_b.label) {
                                    case 0: return [4 /*yield*/, this.userdao.count((_a = {
                                                activityId: activityId
                                            },
                                            _a["taskInfo." + day + "." + task] = { $exists: true },
                                            _a))];
                                    case 1: return [2 /*return*/, _b.sent()];
                                }
                            });
                        }); };
                        keyValueMapper = {
                            时间: day,
                            访问PV: PV,
                            访问UV: UV,
                            新增UV: newUV,
                            '新增UV(通过邀请)': newUVFromInviteUV,
                            '已入会(老会员)PV': vipPV,
                            '已入会(老会员)UV': vipUV,
                            未入会PV: noVipPV,
                            未入会UV: noVipUV,
                            新入会UV: newVipUV,
                            新增关注UV: newFollowUV,
                            助力成功UV: helpSuccessUV
                            //收藏商品任务完成UV: await getTaskCompleteUV('collectGoods', day)
                        };
                        console.log(keyValueMapper, 'xlsxData');
                        if (day === startDay) {
                            xlsxData.push(Object.keys(keyValueMapper));
                        }
                        // @ts-ignore
                        xlsxData.push(Object.values(keyValueMapper));
                        tommorrow = new Date(day).getTime() + oneDay;
                        curDayTimestamp = tommorrow;
                        day = sdk_1.dateFormatter(sdk_1.transformBeijingDate(tommorrow), 'yyyy/MM/dd');
                        return [3 /*break*/, 1];
                    case 13: return [2 /*return*/, xlsxData];
                }
            });
        });
    };
    StatService.prototype.buildExcel = function (startDay, endDay, xlsxData) {
        return __awaiter(this, void 0, void 0, function () {
            var buffer, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        buffer = xlsx.build([
                            {
                                name: "\u6570\u636E\u7EDF\u8BA1" + startDay.replace(/\//g, '-') + "-" + endDay.replace(/\//g, '-'),
                                data: xlsxData
                            }
                        ]);
                        return [4 /*yield*/, this.context.cloud.file.uploadFile({
                                fileContent: buffer,
                                fileName: "\u6570\u636E\u7EDF\u8BA1" + startDay.replace(/\//g, '-') + "-" + endDay.replace(/\//g, '-') + ".xlsx"
                            })];
                    case 1:
                        result = _a.sent();
                        if (result.url) {
                            result.url = result.url.replace('http', 'https').replace('-internal', '');
                        }
                        return [2 /*return*/, result];
                }
            });
        });
    };
    StatService.prototype.getStatCountByquery = function (query) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.statdao.count(query)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    return StatService;
}());
exports.default = StatService;
//# sourceMappingURL=stat.service.js.map