/**
 * 基本信息
 *
 * @format
 */
export default class StatService {
    context: IContext<any>;
    statdao: IBaseDao;
    accessdao: IBaseDao;
    userdao: IBaseDao;
    awardsdao: IBaseDao;
    constructor(context: IContext<IParams>);
    /**
     *  添加数据统计记录
     *
     * @param {number} type  数据类型
     * @param {object} [customStatData={}] 自定义数据
     * @param {IUserInfo} [userInfo] 用户信息
     * @return {boolean}
     * @memberof StatService
     */
    addStat(type: number, userInfo?: IUserInfo, customStatData?: object): Promise<{
        id: string;
    }>;
    getStats(activityId: string, startDay: string, endDay: string): Promise<any>;
    buildExcel(startDay: string, endDay: string, xlsxData: []): Promise<any>;
    getStatCountByquery(query: IMongoQuery): Promise<number>;
}
