"use strict";
/**
 * 基本信息
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../../sdk");
var db_1 = require("../../db");
var utils_1 = require("../../utils");
var user_service_1 = require("./user.service");
var GameService = /** @class */ (function (_super) {
    __extends(GameService, _super);
    function GameService(context) {
        var _this = _super.call(this, context) || this;
        _this.joindao = new sdk_1.BaseDao(context, db_1.JOIN_DB_NAME);
        return _this;
    }
    GameService.prototype.addJoinRecord = function (userInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, openId, activityId, userNick, avatar, now, today, record, id;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.context, openId = _a.openId, activityId = _a.data.activityId;
                        userNick = userInfo.userNick, avatar = userInfo.avatar;
                        now = Date.now();
                        today = utils_1.getToday();
                        record = {
                            activityId: activityId,
                            userNick: userNick,
                            avatar: avatar,
                            openId: openId,
                            createTime: now,
                            updateTime: now,
                            score: 0,
                            createDay: today
                        };
                        return [4 /*yield*/, this.joindao.insertOne(record)];
                    case 1:
                        id = _b.sent();
                        return [2 /*return*/, { id: id }];
                }
            });
        });
    };
    GameService.prototype.submitGame = function (id, score, rankKey, rankTime, userInfo, joinInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var duration, _a, maxScore, totalScore, myRankInfo, gameTimes, avatar, userNick;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.updateJoinRecord(id, score, userInfo, joinInfo)];
                    case 1:
                        duration = (_b.sent()).duration;
                        return [4 /*yield*/, this.updateUserScore(score, userInfo)];
                    case 2:
                        _a = _b.sent(), maxScore = _a.maxScore, totalScore = _a.totalScore;
                        return [4 /*yield*/, this.getMyRankInfo(rankKey, rankTime, userInfo)];
                    case 3:
                        myRankInfo = _b.sent();
                        gameTimes = userInfo.gameTimes, avatar = userInfo.avatar, userNick = userInfo.userNick;
                        return [2 /*return*/, {
                                score: score,
                                maxScore: maxScore,
                                totalScore: totalScore,
                                gameTimes: gameTimes,
                                duration: duration,
                                avatar: avatar,
                                userNick: userNick,
                                rank: myRankInfo.rank
                            }];
                }
            });
        });
    };
    GameService.prototype.updateJoinRecord = function (id, score, userInfo, joinInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var now, today, duration, playInfo;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        now = Date.now();
                        today = utils_1.getToday();
                        duration = now - joinInfo.createTime;
                        playInfo = {
                            score: score,
                            duration: duration,
                            submitTime: now,
                            updateTime: now,
                            submitDay: today
                        };
                        return [4 /*yield*/, this.joindao.update({ _id: id }, { $set: playInfo })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, playInfo];
                }
            });
        });
    };
    GameService.prototype.updateUserScore = function (score, userInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var now, newMaxScore, maxScore, updateScoreTime, _id, totalScore;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        now = Date.now();
                        newMaxScore = score >= (userInfo === null || userInfo === void 0 ? void 0 : userInfo.maxScore);
                        maxScore = newMaxScore ? score : userInfo === null || userInfo === void 0 ? void 0 : userInfo.maxScore;
                        updateScoreTime = newMaxScore ? now : userInfo === null || userInfo === void 0 ? void 0 : userInfo.updateScoreTime;
                        _id = userInfo._id, totalScore = userInfo.totalScore;
                        return [4 /*yield*/, this.updateUser(_id, {
                                $set: { maxScore: maxScore, updateScoreTime: updateScoreTime },
                                $inc: { totalScore: score }
                            })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, {
                                maxScore: maxScore,
                                updateScoreTime: updateScoreTime,
                                totalScore: totalScore + score
                            }];
                }
            });
        });
    };
    return GameService;
}(user_service_1.default));
exports.default = GameService;
//# sourceMappingURL=game.service.js.map