/**
 * 基本信息
 *
 * @format
 */
import UserService from './user.service';
export default class GameService extends UserService {
    context: IContext<IParams>;
    joindao: IBaseDao;
    constructor(context: IContext<IParams>);
    addJoinRecord(userInfo: IUserInfo): Promise<{
        id: string;
    }>;
    submitGame(id: string, score: number, rankKey: string, rankTime: string, userInfo: IUserInfo, joinInfo: IJoinRecord): Promise<{
        score: number;
        maxScore: number;
        totalScore: number;
        gameTimes: number;
        duration: number;
        avatar: string;
        userNick: string;
        rank: number;
    }>;
    updateJoinRecord(id: string, score: number, userInfo: IUserInfo, joinInfo: IJoinRecord): Promise<{
        score: number;
        duration: number;
        submitTime: number;
        updateTime: number;
        submitDay: string;
    }>;
    updateUserScore(score: number, userInfo: IUserInfo): Promise<{
        maxScore: number;
        updateScoreTime: number;
        totalScore: number;
    }>;
}
