"use strict";
/**
 * 奖励
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../../sdk");
var user_service_1 = require("./user.service");
var constants_1 = require("../../constants");
var db_1 = require("../../db");
var utils_1 = require("../../utils");
var helper_1 = require("../../utils/common/helper");
var getToday_1 = require("../../utils/common/getToday");
var AwardsService = /** @class */ (function (_super) {
    __extends(AwardsService, _super);
    function AwardsService(context) {
        var _this = _super.call(this, context) || this;
        _this.awardsdao = new sdk_1.BaseDao(context, db_1.AWARDS_DB_NAME);
        _this.activityprizedao = new sdk_1.BaseDao(context, db_1.PRIZE_CONFIG_DB_NAME);
        return _this;
    }
    // 根据奖品Id扣库存, 扣库存成功返回为1
    AwardsService.prototype.reduceStock = function (_id) {
        return __awaiter(this, void 0, void 0, function () {
            var result, switchStock, stock, useStock, updateResult, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityprizedao.findOne({ _id: _id, deleteStatus: 1 /* NORMAL */ })
                        // 奖品不存在
                    ];
                    case 1:
                        result = _a.sent();
                        // 奖品不存在
                        if (!result) {
                            return [2 /*return*/, constants_1.CODE_TYPES.ERROR_NO_PRIZE];
                        }
                        switchStock = result.switchStock, stock = result.stock, useStock = result.useStock;
                        // 若不限制库存
                        if (switchStock === constants_1.SWICH_TOCK.NO_LIMIT) {
                            return [2 /*return*/, 1];
                        }
                        // 若库存不足
                        if (useStock >= stock) {
                            return [2 /*return*/, constants_1.CODE_TYPES.ERROR_NO_STOCK];
                        }
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, this.activityprizedao.update({
                                _id: _id,
                                $where: 'this.useStock < this.stock'
                            }, {
                                $inc: {
                                    useStock: +1
                                }
                            })];
                    case 3:
                        updateResult = _a.sent();
                        return [2 /*return*/, updateResult ? 1 : constants_1.CODE_TYPES.ERROR_NO_STOCK];
                    case 4:
                        e_1 = _a.sent();
                        console.log("\u6263\u5E93\u5B58\u5931\u8D25\uFF1A", e_1);
                        return [2 /*return*/, constants_1.CODE_TYPES.SYSTEM_ERROR];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    AwardsService.prototype.getMyPrizeList = function (activityInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var openId, activityId, myPrizeList;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        openId = this.context.openId;
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.getAwardsInfoList({
                                openId: openId,
                                activityId: activityId,
                                type: { $ne: constants_1.PRIZE_TYPE.THANKS }
                            }, {
                                projection: {
                                    _id: 1,
                                    name: 1,
                                    image: 1,
                                    type: 1,
                                    drawStatus: 1,
                                    shipStatus: 1,
                                    receiveName: 1,
                                    phone: 1,
                                    address: 1,
                                    provice: 1,
                                    city: 1,
                                    area: 1,
                                    remark: 1,
                                    useUrl: 1,
                                    shipCompany: 1,
                                    shipNum: 1
                                },
                                sort: {
                                    createTime: -1
                                }
                            })];
                    case 1:
                        myPrizeList = _a.sent();
                        return [2 /*return*/, {
                                expiredTime: activityInfo.awardReceiveExpiredTime,
                                list: this.formatMyPrizeList(myPrizeList, activityInfo.awardReceiveExpiredTime)
                            }];
                }
            });
        });
    };
    /**
     * 插入奖品记录
     * @param {*} award
     */
    AwardsService.prototype.addAward = function (award) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.awardsdao.insertOne(__assign(__assign({}, award), { shipStatus: (award === null || award === void 0 ? void 0 : award.type) === constants_1.PRIZE_TYPE.OBJECT ? constants_1.SHIP_STATUS.NO_ADDRESS : '', createTime: Date.now(), updateTime: Date.now() }))];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * 发放奖品
     * @param {*} document
     */
    AwardsService.prototype.sendAward = function (document) {
        return __awaiter(this, void 0, void 0, function () {
            var session, result, _id, update;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, utils_1.getSellerSession(this.context)
                        // 发放淘宝权益
                    ];
                    case 1:
                        session = (_a.sent()).session;
                        return [4 /*yield*/, utils_1.sendTBAward(this.context, session, document)
                            //@ts-ignore
                        ];
                    case 2:
                        result = _a.sent();
                        //@ts-ignore
                        if (result.code) {
                            return [2 /*return*/, result];
                        }
                        _id = document._id;
                        return [4 /*yield*/, this.awardsdao.update({ _id: _id }, {
                                $set: {
                                    drawStatus: document.drawStatus,
                                    remark: document.remark,
                                    updateTime: Date.now()
                                }
                            })];
                    case 3:
                        update = _a.sent();
                        console.log("\u66F4\u65B0\u5956\u54C1\u72B6\u6001", update, document);
                        return [2 /*return*/, document];
                }
            });
        });
    };
    AwardsService.prototype.getAwardsInfoList = function (query, projection) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.awardsdao.find(query, projection)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    AwardsService.prototype.formatMyPrizeList = function (myPrizeList, awardReceiveExpiredTime) {
        var now = Date.now();
        return myPrizeList.map(function (v) {
            if (awardReceiveExpiredTime &&
                now > awardReceiveExpiredTime &&
                [constants_1.DRAW_STATUS.WAITAWARD, constants_1.DRAW_STATUS.RETRY].includes(v.drawStatus)) {
                v.drawStatus = constants_1.DRAW_STATUS.EXPIRED;
                v.remark = "\u5956\u54C1\u5DF2\u8FC7\u671F";
            }
            return __assign(__assign({}, v), { expiredTime: awardReceiveExpiredTime, id: v._id });
        });
    };
    // 领取实物
    AwardsService.prototype.recieveObjectPrize = function (context) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, province, city, area, streetName, addressDetail, id, name, phone, result;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = context.data, province = _a.province, city = _a.city, area = _a.area, streetName = _a.streetName, addressDetail = _a.addressDetail, id = _a.id, name = _a.name, phone = _a.phone;
                        return [4 /*yield*/, this.awardsdao.update({ _id: id }, {
                                $set: {
                                    receiveName: name,
                                    phone: phone,
                                    drawStatus: constants_1.DRAW_STATUS.SUCCESS,
                                    shipStatus: constants_1.SHIP_STATUS.NO_SHIP,
                                    province: province,
                                    city: city,
                                    area: area,
                                    streetName: streetName,
                                    addressDetail: addressDetail,
                                    receiveTime: Date.now(),
                                    updateTime: Date.now()
                                }
                            })];
                    case 1:
                        result = _b.sent();
                        return [2 /*return*/, result
                                ? { province: province, city: city, area: area, streetName: streetName, addressDetail: addressDetail, id: id, name: name, phone: phone }
                                : constants_1.CODE_TYPES.ERROR_RECEIVE_PRIZE];
                }
            });
        });
    };
    // 发放淘宝权益（奖品数据已插入到awards_info表，且状态drawStatus 为1或者6）
    AwardsService.prototype.recieveEnamePrize = function (_id, awardInfo, session) {
        return __awaiter(this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, utils_1.sendTBAward(this.context, session, awardInfo)
                        // 更新
                    ];
                    case 1:
                        result = _a.sent();
                        // 更新
                        return [4 /*yield*/, this.awardsdao.update({ _id: _id }, {
                                $set: {
                                    // @ts-ignore
                                    drawStatus: result.drawStatus,
                                    // @ts-ignore
                                    remark: result.remark,
                                    updateTime: Date.now()
                                }
                            })];
                    case 2:
                        // 更新
                        _a.sent();
                        if (result.remark) {
                            return [2 /*return*/, helper_1.generateCodeTypeWithMsg(constants_1.CODE_TYPES.SYSTEM_ERROR, result.remark)];
                        }
                        return [2 /*return*/, result];
                }
            });
        });
    };
    AwardsService.prototype.drawLottery = function (activityId, prizeDataType, userInfo) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var openId, prizesPool, thanksPrize, prize, reduceResult, type, _id, ename, image, name, useUrl, userNick, record, result;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        openId = this.context.openId;
                        return [4 /*yield*/, this.getPrizeConfig({
                                activityId: activityId,
                                // 根据需求配置筛选条件
                                prizeDataType: prizeDataType
                            })];
                    case 1:
                        prizesPool = _b.sent();
                        thanksPrize = prizesPool.find(function (v) { return v.type === constants_1.PRIZE_TYPE.THANKS; }) || {
                            type: constants_1.PRIZE_TYPE.THANKS,
                            prizeDataType: prizeDataType,
                            name: '谢谢参与'
                        };
                        return [4 /*yield*/, this.getPrizeByProbability(prizesPool)
                            // 未找到奖品,降级到谢谢参与
                        ];
                    case 2:
                        prize = _b.sent();
                        // 未找到奖品,降级到谢谢参与
                        if (!prize) {
                            prize = thanksPrize;
                        }
                        reduceResult = 1;
                        if (!(prize.type !== constants_1.PRIZE_TYPE.CREDITS && prize.type !== constants_1.PRIZE_TYPE.THANKS)) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.reduceStock(prize._id)];
                    case 3:
                        reduceResult = _b.sent();
                        _b.label = 4;
                    case 4:
                        // 扣库存失败降级到谢谢参与
                        if (((_a = reduceResult) === null || _a === void 0 ? void 0 : _a.code) || !reduceResult) {
                            prize = thanksPrize;
                        }
                        type = prize.type, _id = prize._id, ename = prize.ename, image = prize.image, name = prize.name, useUrl = prize.useUrl;
                        userNick = userInfo.userNick;
                        record = {
                            openId: openId,
                            prizeId: _id,
                            activityId: activityId,
                            drawStatus: constants_1.DRAW_STATUS.WAITAWARD,
                            prizeDataType: prizeDataType,
                            remark: '',
                            useUrl: useUrl,
                            type: type,
                            ename: ename,
                            name: name,
                            image: image,
                            userNick: userNick,
                            createDay: getToday_1.getToday()
                        };
                        return [4 /*yield*/, this.addAward(record)];
                    case 5:
                        result = _b.sent();
                        return [2 /*return*/, {
                                id: result,
                                type: type,
                                name: name,
                                image: image
                            }];
                }
            });
        });
    };
    // 根据查询条件获取奖品配置
    AwardsService.prototype.getPrizeConfig = function (query) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.activityprizedao.find(__assign({ deleteStatus: 1 /* NORMAL */ }, query))];
            });
        });
    };
    // 根据概率抽取奖品
    AwardsService.prototype.getPrizeByProbability = function (prizes) {
        return __awaiter(this, void 0, void 0, function () {
            var probability;
            return __generator(this, function (_a) {
                probability = utils_1.rand(10000);
                return [2 /*return*/, prizes.find(function (v) { return probability <= v.properiodto && probability >= v.properiodfrom; })];
            });
        });
    };
    /**
     * 获取活动配置项奖品
     * @param {string} _id
     */
    AwardsService.prototype.getActivityPrizeById = function (_id) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityprizedao.findOne({ _id: _id, deleteStatus: 1 /* NORMAL */ }, {
                            sort: {
                                index: 1
                            }
                        })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    return AwardsService;
}(user_service_1.default));
exports.default = AwardsService;
//# sourceMappingURL=awards.service.js.map