/**
 * 奖励
 *
 * @format
 */
import UserService from './user.service';
export default class AwardsService extends UserService {
    awardsdao: IBaseDao;
    activityprizedao: IBaseDao;
    constructor(context: IContext<IParams>);
    reduceStock(_id: string): Promise<1 | {
        code: string;
        defaultMsg: string;
    }>;
    getMyPrizeList(activityInfo: IActivityInfo): Promise<{
        expiredTime: number;
        list: IAwards[];
    }>;
    /**
     * 插入奖品记录
     * @param {*} award
     */
    addAward(award: IAwards): Promise<string>;
    /**
     * 发放奖品
     * @param {*} document
     */
    sendAward(document: IAwards): Promise<import("taobao-mini-sdk/lib/utils/codetypes").CodeType | IAwards>;
    getAwardsInfoList(query: object, projection?: IFindProjection): Promise<IAwards[]>;
    formatMyPrizeList(myPrizeList: IAwards[], awardReceiveExpiredTime?: number): IAwards[];
    recieveObjectPrize(context: IContext<IParams>): Promise<{
        code: string;
        defaultMsg: string;
    } | {
        province: any;
        city: any;
        area: any;
        streetName: any;
        addressDetail: any;
        id: any;
        name: any;
        phone: any;
    }>;
    recieveEnamePrize(_id: string, awardInfo: IAwards, session: string): Promise<import("taobao-mini-sdk/lib/utils/codetypes").CodeType | IAwards>;
    drawLottery(activityId: string, prizeDataType: number, userInfo: IUserInfo): Promise<{
        id: string;
        type: number;
        name: string;
        image: string;
    }>;
    getPrizeConfig(query: {
        activityId: string;
        [queryParam: string]: any;
    }): Promise<IActivityPrize[]>;
    getPrizeByProbability(prizes: Array<IActivityPrize>): Promise<IActivityPrize>;
    /**
     * 获取活动配置项奖品
     * @param {string} _id
     */
    getActivityPrizeById(_id: string): Promise<unknown>;
}
