"use strict";
/** @format */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CODE_TYPES = exports.BusinessError = void 0;
var sdk_1 = require("./sdk");
exports.BusinessError = {
    // 更新重试失败(用于并发更新)
    ERROR_UPDATE_RETRY: {
        code: "210001",
        defaultMsg: "\u7CFB\u7EDF\u9519\u8BEF"
    },
    // 活动不存在
    ERROR_NO_ACTIVITY: {
        code: "220001",
        defaultMsg: "\u6D3B\u52A8\u4E0D\u5B58\u5728"
    },
    // 活动未开始
    ERROR_ACTIVITY_NOSTART: {
        code: "220002",
        defaultMsg: "\u6D3B\u52A8\u672A\u5F00\u59CB"
    },
    // 活动已结束
    ERROR_ACTIVITY_OVER: {
        code: "220003",
        defaultMsg: "\u6D3B\u52A8\u5DF2\u7ED3\u675F"
    },
    // 活动未结束
    ERROR_ACTIVITY_NO_OVER: {
        code: "220004",
        defaultMsg: "\u6D3B\u52A8\u672A\u7ED3\u675F"
    },
    // 活动已开奖
    ERROR_ACTIVITY_OPENED_PRIZE: {
        code: "220005",
        defaultMsg: "\u6D3B\u52A8\u5DF2\u5F00\u5956"
    },
    // 用户不存在
    ERROR_NO_USER: {
        code: "310002",
        defaultMsg: "\u7528\u6237\u4E0D\u5B58\u5728"
    },
    // 非店铺会员
    ERROR_NO_VIP: {
        code: "310003",
        defaultMsg: '非店铺会员'
    },
    // 未关注店铺
    ERROR_NO_FOLLOW: {
        code: "310004",
        defaultMsg: '未关注店铺'
    },
    // 暂无次数可领取
    ERROR_TASK_NORECEIVE: {
        code: "430001",
        defaultMsg: "\u8BE5\u4EFB\u52A1\u6682\u65E0\u9886\u53D6\u6B21\u6570"
    },
    // 任务奖励已领取
    ERROR_TASK_ALREADYRECEIVE: {
        code: "430002",
        defaultMsg: "\u4EFB\u52A1\u5956\u52B1\u5DF2\u9886\u53D6"
    },
    // 任务已完成
    ERROR_TASK_COMPLETE: {
        code: "430003",
        defaultMsg: "\u4EFB\u52A1\u5DF2\u5B8C\u6210"
    },
    ERROR_INVALID_INVITE_ID: {
        code: "430004",
        defaultMsg: "\u9080\u8BF7\u7801\u65E0\u6548"
    },
    ERROR_NO_CREDITS: {
        code: "430005",
        defaultMsg: "\u4EFB\u52A1\u6240\u9700\u79EF\u5206\u4E0D\u8DB3"
    },
    ERROR_TASK_LIMIT: {
        code: "430006",
        defaultMsg: "\u4ECA\u65E5\u8BE5\u4EFB\u52A1\u6B21\u6570\u8D85\u9650"
    },
    ERROR_AREADY_INVITE_SUCCESS: {
        code: "430007",
        defaultMsg: "\u5DF2\u7ECF\u6210\u529F\u9080\u8BF7\u8FC7"
    },
    ERROR_NO_INVITE_SELF: {
        code: "430008",
        defaultMsg: "\u81EA\u5DF1\u4E0D\u80FD\u7ED9\u81EA\u5DF1\u52A9\u529B"
    },
    ERROR_INVITE: {
        code: "430009",
        defaultMsg: "\u53EA\u6709\u65B0\u4F1A\u5458\u624D\u80FD\u52A9\u529B\u54E6~"
    },
    ERROR_DO_TASK: {
        code: "430010",
        defaultMsg: "\u4EFB\u52A1\u5B8C\u6210\u5931\u8D25~"
    },
    ERROR_FORBIDDEN_OPE: {
        code: "530001",
        defaultMsg: "\u975E\u6CD5\u64CD\u4F5C"
    },
    ERROR_RECEIVE_PRIZE: {
        code: "630002",
        defaultMsg: "\u5956\u52B1\u5DF2\u9886\u53D6"
    },
    ERROR_SEND_PRIZE: {
        code: "730001",
        defaultMsg: "\u53D1\u5956\u5931\u8D25"
    },
    ERROR_NO_PRIZE: {
        code: "730002",
        defaultMsg: "\u5956\u54C1\u4E0D\u5B58\u5728"
    },
    ERROR_NO_STOCK: {
        code: "730003",
        defaultMsg: "\u5E93\u5B58\u4E0D\u8DB3"
    },
    ERROR_PRIZE_EXPIRED: {
        code: "740001",
        defaultMsg: "\u5956\u54C1\u5DF2\u8D85\u8FC7\u9886\u53D6\u65F6\u95F4"
    }
};
exports.CODE_TYPES = Object.assign({}, sdk_1.DEFAULT_CODE_TYPES, exports.BusinessError);
//# sourceMappingURL=errorCode.js.map